package com.bizvane.appletservice.models.po;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

@ApiModel(value="com-bizvane-appletservice-models-po-Members")
@Data
public class Members {
    /**
    * 主键id
    */
    @ApiModelProperty(value="主键id")
    private Long mbrMemberId;

    /**
    * 所属企业id
    */
    @ApiModelProperty(value="所属企业id")
    private Long sysCompanyId;

    /**
    * 品牌id
    */
    @ApiModelProperty(value="品牌id")
    private Long brandId;

    /**
    * 会员code
    */
    @ApiModelProperty(value="会员code")
    private String memberCode;

    /**
    * 会员卡号
    */
    @ApiModelProperty(value="会员卡号")
    private String cardNo;

    /**
    * 线下卡号
    */
    @ApiModelProperty(value="线下卡号")
    private String offlineCardNo;

    /**
    * 线下会员id
    */
    @ApiModelProperty(value="线下会员id")
    private String erpId;

    /**
    * 会员名称
    */
    @ApiModelProperty(value="会员名称")
    private String name;

    /**
    * 会员性别,女:1 男:2 未知:3
    */
    @ApiModelProperty(value="会员性别,女:1 男:2 未知:3")
    private String gender;

    /**
    * 会员手机号
    */
    @ApiModelProperty(value="会员手机号")
    private String phone;

    /**
    * 会员邮箱
    */
    @ApiModelProperty(value="会员邮箱")
    private String email;

    /**
    * 身份证
    */
    @ApiModelProperty(value="身份证")
    private String idCard;

    /**
    * 会员生日
    */
    @ApiModelProperty(value="会员生日")
    private Date birthday;

    /**
    * 冗余生日时间的格式月日,例如：0101
    */
    @ApiModelProperty(value="冗余生日时间的格式月日,例如：0101")
    private String birthdayMd;

    /**
    * 会员省份
    */
    @ApiModelProperty(value="会员省份")
    private String province;

    /**
    * 会员市区
    */
    @ApiModelProperty(value="会员市区")
    private String city;

    /**
    * 会员县
    */
    @ApiModelProperty(value="会员县")
    private String county;

    /**
    * 详细地址
    */
    @ApiModelProperty(value="详细地址")
    private String address;

    /**
    * 会员头像
    */
    @ApiModelProperty(value="会员头像")
    private String headPortraits;

    /**
    * 会员卡条形码
    */
    @ApiModelProperty(value="会员卡条形码")
    private String barCode;

    /**
    * 微信绑卡状态1：未绑卡,2已绑卡
    */
    @ApiModelProperty(value="微信绑卡状态1：未绑卡,2已绑卡")
    private Integer cardStatus;

    /**
    * 会员体系编码
    */
    @ApiModelProperty(value="会员体系编码")
    private String memberSysId;

    /**
    * 开卡时间
    */
    @ApiModelProperty(value="开卡时间")
    private Date openCardTime;

    /**
    * 微信渠道关联会员时间
    */
    @ApiModelProperty(value="微信渠道关联会员时间")
    private Date bindCardTime;

    /**
    * 有效期
    */
    @ApiModelProperty(value="有效期")
    private Date effectiveTime;

    /**
    * 推广渠道
    */
    @ApiModelProperty(value="推广渠道")
    private String generalizeChannel;

    /**
    * 开卡渠道id
    */
    @ApiModelProperty(value="开卡渠道id")
    private Long openCardChannelId;

    /**
    * 全渠道会员卡
    */
    @ApiModelProperty(value="全渠道会员卡")
    private String allChannelIds;

    /**
    * 线下归属经销商
    */
    @ApiModelProperty(value="线下归属经销商")
    private Long offlineDealerAttributionId;

    /**
    * 开卡导购id
    */
    @ApiModelProperty(value="开卡导购id")
    private Long openCardGuideId;

    /**
    * 开卡门店id
    */
    @ApiModelProperty(value="开卡门店id")
    private Long openCardStoreId;

    /**
    * 服务门店id
    */
    @ApiModelProperty(value="服务门店id")
    private Long serviceStoreId;

    /**
    * 服务导购id
    */
    @ApiModelProperty(value="服务导购id")
    private Long serviceGuideId;

    /**
    * 活跃门店(快照)
    */
    @ApiModelProperty(value="活跃门店(快照)")
    private String activeStore;

    /**
    * 微信推广渠道
    */
    @ApiModelProperty(value="微信推广渠道")
    private String wxGeneralizeChannel;

    /**
    * 微信openid
    */
    @ApiModelProperty(value="微信openid")
    private String wxOpenId;

    /**
    * 微信unionid
    */
    @ApiModelProperty(value="微信unionid")
    private String wxUnionId;

    /**
    * 微信公众号id
    */
    @ApiModelProperty(value="微信公众号id")
    private Short wxPublicId;

    /**
    * 会员等级
    */
    @ApiModelProperty(value="会员等级")
    private Long levelId;

    /**
    * 会员标签
    */
    @ApiModelProperty(value="会员标签")
    private String labelIds;

    /**
    * 标签名称
    */
    @ApiModelProperty(value="标签名称")
    private String labelNames;

    /**
    * 自定义会员标签
    */
    @ApiModelProperty(value="自定义会员标签")
    private String customLabelIds;

    /**
    * 自定义会员标签名称
    */
    @ApiModelProperty(value="自定义会员标签名称")
    private String customLabelNames;

    /**
    * 拓展字段值id
    */
    @ApiModelProperty(value="拓展字段值id")
    private String extendIds;

    /**
    * 分销状态：1启用分销；0禁止分销
    */
    @ApiModelProperty(value="分销状态：1启用分销；0禁止分销")
    private Boolean distributionState;

    /**
    * 分销创建人
    */
    @ApiModelProperty(value="分销创建人")
    private String distributionCreateName;

    /**
    * 分销会员创建时间
    */
    @ApiModelProperty(value="分销会员创建时间")
    private Date distributionCreateTime;

    @ApiModelProperty(value="")
    private String distributionModifiedName;

    /**
    * 启用时间
    */
    @ApiModelProperty(value="启用时间")
    private Date distributionModifiedTime;

    /**
    * 是否首次登录：1是，2否
    */
    @ApiModelProperty(value="是否首次登录：1是，2否")
    private Boolean firstLandingCheck;

    /**
    * vip卡状态 0未激活 1激活 2停用 3挂失 4冻结 5线上存在未写线下
    */
    @ApiModelProperty(value="vip卡状态 0未激活 1激活 2停用 3挂失 4冻结 5线上存在未写线下")
    private Integer cardUseStatus;

    /**
    * 充值余额
    */
    @ApiModelProperty(value="充值余额")
    private BigDecimal balance;

    /**
    * 数据有效性：1=有效；0=无效
    */
    @ApiModelProperty(value="数据有效性：1=有效；0=无效")
    private Boolean valid;

    /**
    * 备注
    */
    @ApiModelProperty(value="备注")
    private String remark;

    /**
    * 创建人id
    */
    @ApiModelProperty(value="创建人id")
    private Long createUserId;

    /**
    * 创建人
    */
    @ApiModelProperty(value="创建人")
    private String createUserName;

    /**
    * 创建日期
    */
    @ApiModelProperty(value="创建日期")
    private Date createDate;

    /**
    * 修改人id
    */
    @ApiModelProperty(value="修改人id")
    private Long modifiedUserId;

    /**
    * 修改人
    */
    @ApiModelProperty(value="修改人")
    private String modifiedUserName;

    /**
    * 修改时间
    */
    @ApiModelProperty(value="修改时间")
    private Date modifiedDate;

    /**
    * 版本号
    */
    @ApiModelProperty(value="版本号")
    private Integer version;

    /**
    * 同步ElasticSearch最后修改时间
    */
    @ApiModelProperty(value="同步ElasticSearch最后修改时间")
    private Date lastEsTime;

    /**
    * 线下企业code
    */
    @ApiModelProperty(value="线下企业code")
    private String offlineCompanyCode;

    /**
    * 线下品牌code
    */
    @ApiModelProperty(value="线下品牌code")
    private String offlineBrandCode;

    /**
    * 线下经销商code
    */
    @ApiModelProperty(value="线下经销商code")
    private String offlineDealerAttributionCode;

    /**
    * 归属经销商名
    */
    @ApiModelProperty(value="归属经销商名")
    private String dealerAttributionName;

    /**
    * 开卡导购线下code
    */
    @ApiModelProperty(value="开卡导购线下code")
    private String openCardGuideCode;

    /**
    * 开卡店铺线下code
    */
    @ApiModelProperty(value="开卡店铺线下code")
    private String openCardStoreCode;

    /**
    * 服务门店线下code
    */
    @ApiModelProperty(value="服务门店线下code")
    private String serviceStoreCode;

    /**
    * 服务导购线下code
    */
    @ApiModelProperty(value="服务导购线下code")
    private String serviceGuideCode;

    /**
    * 线下等级code
    */
    @ApiModelProperty(value="线下等级code")
    private String offlineLevelCode;

    /**
    * 会员累计可用总积分
    */
    @ApiModelProperty(value="会员累计可用总积分")
    private Integer countIntegral;

    /**
    * 累计收入的总积分
    */
    @ApiModelProperty(value="累计收入的总积分")
    private Integer addUpIntegral;

    /**
    * 即将到期积分
    */
    @ApiModelProperty(value="即将到期积分")
    private Integer aboutExpireIntegral;

    /**
    * 即将到期时间
    */
    @ApiModelProperty(value="即将到期时间")
    private Date aboutExpireTime;

    /**
    * 线下更新时间
    */
    @ApiModelProperty(value="线下更新时间")
    private Date offlineUpdateDate;

    /**
    * 已过期积分
    */
    @ApiModelProperty(value="已过期积分")
    private Integer pastDueIntegral;

    /**
    * 已消耗积分
    */
    @ApiModelProperty(value="已消耗积分")
    private Integer consumeIntegral;

    /**
    * 冻结积分
    */
    @ApiModelProperty(value="冻结积分")
    private Integer freezeIntegral;

    /**
    * 积分兑换券次数
    */
    @ApiModelProperty(value="积分兑换券次数")
    private Integer integralExchangeTicketCount;

    /**
    * 会员来源某某分配
    */
    @ApiModelProperty(value="会员来源某某分配")
    private String membersFrom;

    /**
    * 会员来源时间
    */
    @ApiModelProperty(value="会员来源时间")
    private Date dateFrom;

    /**
    * 会员标注 0=未读；1已读
    */
    @ApiModelProperty(value="会员标注 0=未读；1已读")
    private Integer mark;

    /**
    * 是否企业好友 1=是 0=否(保留字段)
    */
    @ApiModelProperty(value="是否企业好友 1=是 0=否(保留字段)")
    private Integer companyFriend;

    /**
    * 会员导购好友集合，以-隔开
    */
    @ApiModelProperty(value="会员导购好友集合，以-隔开")
    private String companyGuideFriends;

    /**
    * 会员备注
    */
    @ApiModelProperty(value="会员备注")
    private String memberComment;

    /**
    * 好友userid
    */
    @ApiModelProperty(value="好友userid")
    private String externalUserId;

    /**
    * 会员积分线下更改时间
    */
    @ApiModelProperty(value="会员积分线下更改时间")
    private Date offlineUpdateIntegralDate;

    /**
    * 活动id
    */
    @ApiModelProperty(value="活动id")
    private Long activityId;

    /**
    * 活动类型
    */
    @ApiModelProperty(value="活动类型")
    private Integer activityType;

    /**
    * 开卡场景 30扫码开卡 20绑卡 10自选开卡门店 0默认开卡门店(小于10可改)
    */
    @ApiModelProperty(value="开卡场景 30扫码开卡 20绑卡 10自选开卡门店 0默认开卡门店(小于10可改)")
    private Integer openCardScene;

    /**
    * 二维码渠道
    */
    @ApiModelProperty(value="二维码渠道")
    private Integer channel;

    /**
    * 升级时间
    */
    @ApiModelProperty(value="升级时间")
    private Date levelUpTime;

    /**
    * 降级时间
    */
    @ApiModelProperty(value="降级时间")
    private Date levelDownTime;

    /**
    * 宝宝生日
    */
    @ApiModelProperty(value="宝宝生日")
    private Date babyBirthday;

    /**
    * 宝宝生日 MMdd
    */
    @ApiModelProperty(value="宝宝生日 MMdd")
    private String babyBirthdayMd;

    /**
    * 首单时间
    */
    @ApiModelProperty(value="首单时间")
    private Date firstOrderTime;

    /**
    * 储值卡号
    */
    @ApiModelProperty(value="储值卡号")
    private String petCard;

    /**
    * 余额修改日期
    */
    @ApiModelProperty(value="余额修改日期")
    private Date offlineUpdateBalanceDate;

    /**
    * ur注册类型
    */
    @ApiModelProperty(value="ur注册类型")
    private Integer registerType;

    /**
    * 邮箱验证状态 0未验证 1已验证
    */
    @ApiModelProperty(value="邮箱验证状态 0未验证 1已验证")
    private Integer emailStatus;
}