package com.bizvane.appletservice.models.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class OrderEvaluateVo extends BaseModelBo implements Serializable {
    private static final long serialVersionUID = -3520231760075808796L;

    @ApiModelProperty(
            value = "订单评价主键",
            name = "mbrOrderEvaluateId",
            example = "订单评价主键"
    )
    private Long mbrOrderEvaluateId;
    @ApiModelProperty(
            value = "企业id",
            name = "brandId",
            example = "企业id"
    )
    private Long sysCompanyId;
    @ApiModelProperty(
            value = "品牌id",
            name = "brandId",
            example = "品牌id"
    )
    private Long brandId;
    @ApiModelProperty(
            value = "所属订单",
            name = "orderNo",
            example = "所属订单"
    )
    private String orderNo;
    @ApiModelProperty(
            value = "商品评均分",
            name = "productScore",
            example = "商品评均分"
    )
    private Double productScore;
    @ApiModelProperty(
            value = "店铺环境评分（最高5分）",
            name = "storeEnvironmentGrade",
            example = "店铺环境评分（最高5分）"
    )
    private Integer storeEnvironmentGrade;
    @ApiModelProperty(
            value = "店铺服务评分（最高5分）",
            name = "storeServerGrade",
            example = "店铺服务评分（最高5分）"
    )
    private Integer storeServerGrade;
    @ApiModelProperty(
            value = "评价时间",
            name = "evaluateTime",
            example = "评价时间"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date evaluateTime;
    @ApiModelProperty(
            value = "店铺名称",
            name = "storeName",
            example = "店铺名称"
    )
    private String storeName;
    @ApiModelProperty(
            value = "服务导购名称",
            name = "guideName",
            example = "服务导购名称"
    )
    private String guideName;
    @ApiModelProperty(
            value = "店铺id",
            name = "storeId",
            example = "店铺id"
    )
    private Integer storeId;
    @ApiModelProperty(
            value = "导购id",
            name = "guideId",
            example = "导购id"
    )
    private Integer guideId;
    @ApiModelProperty(
            value = "评价会员code",
            name = "evaluateMemberCode",
            example = "评价会员code"
    )
    private String evaluateMemberCode;
    @ApiModelProperty(
            value = "会员所属门店",
            name = "serviceStoreId",
            example = "评价会员所属门店"
    )
    private Long serviceStoreId;
    @ApiModelProperty(
            value = "订单会员名",
            name = "name",
            example = "订单会员名"
    )
    private String name;
    @ApiModelProperty(
            value = "订单会员手机",
            name = "phone",
            example = "订单会员手机"
    )
    private String phone;
    @ApiModelProperty(
            value = "订单详细评价",
            name = "orderDetailEvaluateModelList",
            example = "订单详细评价"
    )
    private String orderDetailEvaluateModelList;
    @ApiModelProperty(
            value = "图片存储域名",
            name = "domain",
            example = "图片存储域名"
    )
    private String domain;
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date orderTime; //订单时间

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getMbrOrderEvaluateId() {
        return mbrOrderEvaluateId;
    }

    public void setMbrOrderEvaluateId(Long mbrOrderEvaluateId) {
        this.mbrOrderEvaluateId = mbrOrderEvaluateId;
    }

    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Double getProductScore() {
        return productScore;
    }

    public void setProductScore(Double productScore) {
        this.productScore = productScore;
    }

    public Integer getStoreEnvironmentGrade() {
        return storeEnvironmentGrade;
    }

    public void setStoreEnvironmentGrade(Integer storeEnvironmentGrade) {
        this.storeEnvironmentGrade = storeEnvironmentGrade;
    }

    public Integer getStoreServerGrade() {
        return storeServerGrade;
    }

    public void setStoreServerGrade(Integer storeServerGrade) {
        this.storeServerGrade = storeServerGrade;
    }

    public Date getEvaluateTime() {
        return evaluateTime;
    }

    public void setEvaluateTime(Date evaluateTime) {
        this.evaluateTime = evaluateTime;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getGuideName() {
        return guideName;
    }

    public void setGuideName(String guideName) {
        this.guideName = guideName;
    }

    public Integer getStoreId() {
        return storeId;
    }

    public void setStoreId(Integer storeId) {
        this.storeId = storeId;
    }

    public Integer getGuideId() {
        return guideId;
    }

    public void setGuideId(Integer guideId) {
        this.guideId = guideId;
    }

    public String getEvaluateMemberCode() {
        return evaluateMemberCode;
    }

    public void setEvaluateMemberCode(String evaluateMemberCode) {
        this.evaluateMemberCode = evaluateMemberCode;
    }

    public Long getServiceStoreId() {
        return serviceStoreId;
    }

    public void setServiceStoreId(Long serviceStoreId) {
        this.serviceStoreId = serviceStoreId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOrderDetailEvaluateModelList() {
        return orderDetailEvaluateModelList;
    }

    public void setOrderDetailEvaluateModelList(String orderDetailEvaluateModelList) {
        this.orderDetailEvaluateModelList = orderDetailEvaluateModelList;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }
}
