package com.bizvane.appletservice.models.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

public class OrderDetailEvaluateBo {
    private static final long serialVersionUID = 353469785629083983L;
    @ApiModelProperty(
            value = "订单评价详情主键",
            name = "mbrOrderDetailEvaluateId",
            example = "订单评价详情主键"
    )
    private Long mbrOrderDetailEvaluateId;
    @ApiModelProperty(
            value = "企业id",
            name = "sysCompanyId",
            example = "企业id"
    )
    private Long sysCompanyId;
    @ApiModelProperty(
            value = "品牌id",
            name = "brandId",
            example = "品牌id"
    )
    private Long brandId;
    @ApiModelProperty(
            value = "所属订单",
            name = "orderNo",
            example = "所属订单"
    )
    private String orderNo;
    @ApiModelProperty(
            value = "所属订单详情编号",
            name = "orderDetailNo",
            example = "所属订单详情编号"
    )
    private String orderDetailNo;
    @ApiModelProperty(
            value = "评价时间",
            name = "evaluateTime",
            example = "评价时间"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date evaluateTime;
    @ApiModelProperty(
            value = "评价内容",
            name = "evaluateContent",
            example = "评价内容"
    )
    private String evaluateContent;
    @ApiModelProperty(
            value = "评价图片",
            name = "evaluatePicture",
            example = "评价图片"
    )
    private String evaluatePicture;
    @ApiModelProperty(
            value = "评分（最高5分）",
            name = "evaluateScore",
            example = "评分（最高5分）"
    )
    private Integer evaluateScore;
    @ApiModelProperty(
            value = "评价会员code",
            name = "evaluateMemberCode",
            example = "评价会员code"
    )
    private String evaluateMemberCode;
    @ApiModelProperty(
            value = "会员所属门店",
            name = "serviceStoreId",
            example = "评价会员所属门店"
    )
    private Long serviceStoreId;
    @ApiModelProperty(
            value = "商品名",
            name = "productName",
            example = "商品名"
    )
    private String productName;
    @ApiModelProperty(
            value = "商品编号",
            name = "productNo",
            example = "商品编号"
    )
    private String productNo;
    @ApiModelProperty(
            value = "颜色",
            name = "specification",
            example = "颜色"
    )
    private String color;
    @ApiModelProperty(
            value = "大小",
            name = "specification",
            example = "大小"
    )
    private String size;
    @ApiModelProperty(
            value = "线下更新时间",
            name = "offlineUpdateDate",
            example = "线下更新时间"
    )
    private Date offlineUpdateDate;
    @ApiModelProperty(
            value = "线下企业code",
            name = "offlineCompanyCode",
            example = "线下企业code"
    )
    private String offlineCompanyCode;
    @ApiModelProperty(
            value = "线下品牌code",
            name = "offlineBrandCode",
            example = "线下品牌code"
    )
    private String offlineBrandCode;
    private List<String> evaluatePictureList;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getMbrOrderDetailEvaluateId() {
        return mbrOrderDetailEvaluateId;
    }

    public void setMbrOrderDetailEvaluateId(Long mbrOrderDetailEvaluateId) {
        this.mbrOrderDetailEvaluateId = mbrOrderDetailEvaluateId;
    }

    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderDetailNo() {
        return orderDetailNo;
    }

    public void setOrderDetailNo(String orderDetailNo) {
        this.orderDetailNo = orderDetailNo;
    }

    public Date getEvaluateTime() {
        return evaluateTime;
    }

    public void setEvaluateTime(Date evaluateTime) {
        this.evaluateTime = evaluateTime;
    }

    public String getEvaluateContent() {
        return evaluateContent;
    }

    public void setEvaluateContent(String evaluateContent) {
        this.evaluateContent = evaluateContent;
    }

    public String getEvaluatePicture() {
        return evaluatePicture;
    }

    public void setEvaluatePicture(String evaluatePicture) {
        this.evaluatePicture = evaluatePicture;
    }

    public Integer getEvaluateScore() {
        return evaluateScore;
    }

    public void setEvaluateScore(Integer evaluateScore) {
        this.evaluateScore = evaluateScore;
    }

    public String getEvaluateMemberCode() {
        return evaluateMemberCode;
    }

    public void setEvaluateMemberCode(String evaluateMemberCode) {
        this.evaluateMemberCode = evaluateMemberCode;
    }

    public Long getServiceStoreId() {
        return serviceStoreId;
    }

    public void setServiceStoreId(Long serviceStoreId) {
        this.serviceStoreId = serviceStoreId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductNo() {
        return productNo;
    }

    public void setProductNo(String productNo) {
        this.productNo = productNo;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public Date getOfflineUpdateDate() {
        return offlineUpdateDate;
    }

    public void setOfflineUpdateDate(Date offlineUpdateDate) {
        this.offlineUpdateDate = offlineUpdateDate;
    }

    public String getOfflineCompanyCode() {
        return offlineCompanyCode;
    }

    public void setOfflineCompanyCode(String offlineCompanyCode) {
        this.offlineCompanyCode = offlineCompanyCode;
    }

    public String getOfflineBrandCode() {
        return offlineBrandCode;
    }

    public void setOfflineBrandCode(String offlineBrandCode) {
        this.offlineBrandCode = offlineBrandCode;
    }

    public List<String> getEvaluatePictureList() {
        return evaluatePictureList;
    }

    public void setEvaluatePictureList(List<String> evaluatePictureList) {
        this.evaluatePictureList = evaluatePictureList;
    }
}
