package com.bizvane.appletservice.interfaces.goldlion;

import com.bizvane.customized.facade.models.vo.goldLion.biz.BizGoldLionMemberActivityVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListReqVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.MemberActivityListResVo;
import com.bizvane.customized.facade.models.vo.goldLion.biz.TakeEquityReqVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by zhouyuming on 2020-04-20.
 */
public interface GoldlionMemberActivityService {

    /**
     * 领取会员活动权益
     *
     * @param takeEquityReqVo
     * @return
     */
    ResponseData takeEquity(TakeEquityReqVo takeEquityReqVo);

    /**
     * 权益活动列表
     *
     * @param memberActivityListReqVo
     * @return
     */
    @PostMapping(value = "memberActivityList")
    ResponseData<List<MemberActivityListResVo>> memberActivityList(@RequestBody MemberActivityListReqVo memberActivityListReqVo);

    /**
     * 活动详情查看
     *
     * @param cusGoldlionMemberActivityId
     * @return
     */
    @GetMapping(value = "getById")
    ResponseData<BizGoldLionMemberActivityVo> getById(@RequestParam Long cusGoldlionMemberActivityId);
}
