package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.AppletVipCardBo;
import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * 会员特权
 *
 * @author gs
 */
public interface MemberPrivilegeService {
    /**
     * 获取品牌下的会员卡特权信息
     *
     * @param sysBrandId
     * @return
     */
    ResponseData<List<AppletVipCardBo>> getMemberPrivilege(Long sysBrandId);
    /**
     * 根据等级 id 获取相对特权信息
     *
     * @param appletVipCardId
     * @return
     */
    ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegebyGrder(Long appletVipCardId);
    /**
     * 查看会员卡特权详情
     *
     * @param appletVipPrivilegeId
     * @return
     */
    ResponseData<List<AppletVipPrivilegePO>> getMemberPrivilegeAll(Long appletVipPrivilegeId);
}
