package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.po.Members;
import com.bizvane.appletservice.models.vo.ActivityRegistrationVO;
import com.bizvane.mktcenterservice.models.vo.PageForm;
import com.bizvane.mktcenterservice.models.vo.SignupHistory;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

public interface ActivityRegistrationService {
    ResponseData<ActivityRegistrationVO> getActivityRegistrationDetail(String activityCode, String memberCode);

    ResponseData<PageInfo<ActivityRegistrationVO>> getActivityRegistrationList(PageForm pageForm);

    ResponseData<Object> signup(String activityCode, Map<String, String> customProperties, String memberCode);

    ResponseData<Object> signup4others(String activityCode, Map<String, String> customProperties, String memberCode);

    ResponseData<Object> signin(String activityCode, String phone);

    ResponseData<List<SignupHistory>> signupHistory(String memberCode);

    String selectMemberCodeByOpenId(String openid);

    Members getMemberByOpenid(String openid);
}
