package com.bizvane.ajhfacade.rpc;

import com.bizvane.ajhfacade.models.po.Project;
import com.bizvane.ajhfacade.vo.ProjectVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import java.util.List;

@FeignClient(value = "${feign.client.ajh.name}",path = "${feign.client.ajh.path}/projectRpc")
public interface ProjectRpcService {

    /**
     * 查询项目列表
     *
     * @return
     */
    @RequestMapping(value = "/getProjectListRpc", method = RequestMethod.POST)
    ResponseData<List<Project>> getProjectList(@RequestBody ProjectVO project);

}
