/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.ErrorWrapper;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.TaskCall;
import org.frameworkset.elasticsearch.serial.CharEscapeUtil;
import org.frameworkset.elasticsearch.template.ESUtil;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCRestClientUtil
extends ErrorWrapper {
    private static Logger logger = LoggerFactory.getLogger(JDBCRestClientUtil.class);
    private ClientInterface clientInterface;
    private ESJDBC jdbcResultSet;

    public JDBCRestClientUtil() {
        this.clientInterface = ElasticSearchHelper.getRestClientUtil();
    }

    public JDBCRestClientUtil(String esCluster) {
        this.clientInterface = ElasticSearchHelper.getRestClientUtil((String)esCluster);
    }

    private String parallelBatchExecute(String indexName, String indexType, int batchsize, String refreshOption) {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        ExecutorService service = this.jdbcResultSet.buildThreadPool();
        ArrayList<Future> tasks = new ArrayList<Future>();
        int taskNo = 0;
        try {
            String datas;
            while (this.jdbcResultSet.next()) {
                if (this.error != null && !this.jdbcResultSet.isContinueOnError()) {
                    throw this.error;
                }
                JDBCRestClientUtil.evalBuilk((Writer)writer, indexName, indexType, this.jdbcResultSet, "index");
                if (++count != batchsize) continue;
                writer.flush();
                datas = builder.toString();
                builder.setLength(0);
                writer.close();
                writer = new BBossStringWriter(builder);
                count = 0;
                tasks.add(service.submit(new TaskCall(refreshOption, datas, this, taskNo)));
                ++taskNo;
            }
            if (count > 0) {
                if (this.error != null && !this.jdbcResultSet.isContinueOnError()) {
                    throw this.error;
                }
                writer.flush();
                datas = builder.toString();
                tasks.add(service.submit(new TaskCall(refreshOption, datas, this, taskNo)));
            }
        }
        catch (SQLException e) {
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            this.waitTasksComplete(this.jdbcResultSet, tasks, service);
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    private String batchExecute(String indexName, String indexType, int batchsize, String refreshOption) {
        int count = 0;
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        String ret = null;
        int taskNo = 0;
        try {
            String datas;
            while (this.jdbcResultSet.next()) {
                JDBCRestClientUtil.evalBuilk((Writer)writer, indexName, indexType, this.jdbcResultSet, "index");
                if (++count != batchsize) continue;
                writer.flush();
                datas = builder.toString();
                builder.setLength(0);
                writer.close();
                writer = new BBossStringWriter(builder);
                count = 0;
                ++taskNo;
                if (refreshOption == null) {
                    ret = this.clientInterface.executeHttp("_bulk", datas, "post");
                    continue;
                }
                ret = this.clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post");
            }
            if (count > 0) {
                writer.flush();
                datas = builder.toString();
                if (refreshOption == null) {
                    this.clientInterface.executeHttp("_bulk", datas, "post");
                } else {
                    this.clientInterface.executeHttp("_bulk?" + refreshOption, datas, "post");
                }
            }
        }
        catch (SQLException e) {
            throw new ElasticSearchException((Throwable)e);
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException((Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addDocuments(String indexName, String indexType, ESJDBC jdbcResultSet, String refreshOption, int batchsize) throws ElasticSearchException {
        if (jdbcResultSet == null) return null;
        if (jdbcResultSet.getResultSet() == null) {
            return null;
        }
        this.jdbcResultSet = jdbcResultSet;
        if (batchsize <= 0) {
            builder = new StringBuilder();
            writer = new BBossStringWriter(builder);
            ** try [egrp 1[TRYBLOCK] [1 : 43->78)] { 
lbl10:
            // 1 sources

        } else {
            if (jdbcResultSet.getThreadCount() > 0 && jdbcResultSet.isParallel()) {
                var6_7 = this.parallelBatchExecute(indexName, indexType, batchsize, refreshOption);
                return var6_7;
            }
            var6_8 = this.batchExecute(indexName, indexType, batchsize, refreshOption);
            return var6_8;
        }
        finally {
            jdbcResultSet.destroy();
        }
        {
            while (jdbcResultSet.next()) {
                try {
                    JDBCRestClientUtil.evalBuilk((Writer)writer, indexName, indexType, jdbcResultSet, "index");
                }
                catch (Exception e) {
                    throw new ElasticSearchException((Throwable)e);
                }
            }
        }
lbl26:
        // 1 sources

        catch (SQLException e) {
            throw new ElasticSearchException((Throwable)e);
        }
        writer.flush();
        if (refreshOption == null) {
            var8_12 = this.clientInterface.executeHttp("_bulk", builder.toString(), "post");
            return var8_12;
        }
        var8_13 = this.clientInterface.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
        return var8_13;
    }

    private void waitTasksComplete(ESJDBC jdbcResultSet, final List<Future> tasks, final ExecutorService service) {
        if (!jdbcResultSet.isAsyn()) {
            for (Future future : tasks) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        logger.error("", e.getCause());
                        continue;
                    }
                    logger.error("", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
            service.shutdown();
        } else {
            Thread completeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (Future future : tasks) {
                        try {
                            future.get();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() != null) {
                                logger.error("", e.getCause());
                                continue;
                            }
                            logger.error("", (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error("", (Throwable)e);
                        }
                    }
                    service.shutdown();
                }
            });
            completeThread.start();
        }
    }

    private Object handleDate(ResultSet row, int i) {
        Comparable<Integer> value;
        block6: {
            value = null;
            try {
                try {
                    value = row.getTimestamp(i + 1);
                    if (value != null) {
                        value = ((Timestamp)value).getTime();
                        break block6;
                    }
                    value = 0;
                }
                catch (Exception e) {
                    value = row.getDate(i + 1);
                    if (value != null) {
                        value = ((Date)value).getTime();
                        break block6;
                    }
                    value = 0;
                }
            }
            catch (Exception e) {
                value = 0;
            }
        }
        return value;
    }

    private static Object getValue(ResultSet row, int i, String colName) throws Exception {
        Object value = row.getObject(i + 1);
        return value;
    }

    private static Object getFileValue(ESJDBC jdbcResultSet, String fileName) throws SQLException {
        if (fileName != null) {
            Object id = jdbcResultSet.getResultSet().getObject(fileName);
            return id;
        }
        return null;
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, ESJDBC jdbcResultSet, String action) throws Exception {
        Object id = JDBCRestClientUtil.getFileValue(jdbcResultSet, jdbcResultSet.getEsIdField());
        Object parentId = JDBCRestClientUtil.getFileValue(jdbcResultSet, jdbcResultSet.getEsParentIdField());
        Object routing = JDBCRestClientUtil.getFileValue(jdbcResultSet, jdbcResultSet.getRoutingField());
        if (routing == null) {
            routing = jdbcResultSet.getRoutingValue();
        }
        Integer esRetryOnConflict = jdbcResultSet.getEsRetryOnConflict();
        JDBCRestClientUtil.buildMeta(writer, indexType, indexName, jdbcResultSet, action, id, parentId, routing, esRetryOnConflict);
    }

    public static void buildMeta(Writer writer, String indexType, String indexName, ESJDBC esjdbc, String action, Object id, Object parentId, Object routing, Object esRetryOnConflict) throws Exception {
        if (id != null) {
            String versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            writer.write("\", \"_id\" : ");
            BuildTool.buildId((Object)id, (Writer)writer, (boolean)true);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = JDBCRestClientUtil.getFileValue(esjdbc, esjdbc.getEsVersionField())) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = esjdbc.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write(" } }\n");
        } else {
            String versionType;
            Object version;
            writer.write("{ \"");
            writer.write(action);
            writer.write("\" : { \"_index\" : \"");
            writer.write(indexName);
            writer.write("\", \"_type\" : \"");
            writer.write(indexType);
            if (parentId != null) {
                writer.write(", \"parent\" : ");
                BuildTool.buildId((Object)parentId, (Writer)writer, (boolean)true);
            }
            if (routing != null) {
                writer.write(", \"_routing\" : ");
                BuildTool.buildId((Object)routing, (Writer)writer, (boolean)true);
            }
            if (esRetryOnConflict != null) {
                writer.write(",\"_retry_on_conflict\":");
                writer.write(String.valueOf(esRetryOnConflict));
            }
            if ((version = JDBCRestClientUtil.getFileValue(esjdbc, esjdbc.getEsVersionField())) != null) {
                writer.write(",\"_version\":");
                writer.write(String.valueOf(version));
            }
            if ((versionType = esjdbc.getEsVersionType()) != null) {
                writer.write(",\"_version_type\":\"");
                writer.write(String.valueOf(versionType));
                writer.write("\"");
            }
            writer.write("\" } }\n");
        }
    }

    public static void evalBuilk(Writer writer, String indexName, String indexType, ESJDBC jdbcResultSet, String action) throws Exception {
        if (jdbcResultSet != null) {
            BuildTool.buildMeta((Writer)writer, (String)indexType, (String)indexName, (Object)((Object)jdbcResultSet), (String)action);
            if (!action.equals("update")) {
                JDBCRestClientUtil.serialResult(writer, jdbcResultSet);
            } else {
                writer.write("{\"doc\":");
                JDBCRestClientUtil.serialResult(writer, jdbcResultSet);
                if (jdbcResultSet.getEsDocAsUpsert() != null) {
                    writer.write(",\"doc_as_upsert\":");
                    writer.write(String.valueOf(jdbcResultSet.getEsDocAsUpsert()));
                }
                if (jdbcResultSet.getEsReturnSource() != null) {
                    writer.write(",\"_source\":");
                    writer.write(String.valueOf(jdbcResultSet.getEsReturnSource()));
                }
                writer.write("}\n");
            }
        }
    }

    private static void serialResult(Writer writer, ESJDBC esjdbc) throws Exception {
        PoolManResultSetMetaData metaData = esjdbc.getMetaData();
        int counts = metaData.getColumnCount();
        writer.write("{");
        Boolean useJavaName = esjdbc.getUseJavaName();
        if (useJavaName == null) {
            useJavaName = true;
        }
        for (int i = 0; i < counts; ++i) {
            String colName = metaData.getColumnLabelUpperByIndex(i);
            if ("ROWNUM__".equals(colName)) continue;
            String javaName = null;
            FieldMeta fieldMeta = esjdbc.getMappingName(colName);
            if (fieldMeta != null) {
                if (fieldMeta.getIgnore() != null && fieldMeta.getIgnore().booleanValue()) continue;
                javaName = fieldMeta.getEsFieldName();
            } else {
                String string = javaName = useJavaName != false ? metaData.getColumnJavaNameByIndex(i) : colName;
            }
            if (javaName == null) {
                javaName = colName;
            }
            if (i > 0) {
                writer.write(",");
            }
            writer.write("\"");
            writer.write(javaName);
            writer.write("\":");
            Object value = JDBCRestClientUtil.getValue(esjdbc.getResultSet(), i, colName);
            if (value != null) {
                CharEscapeUtil charEscapeUtil;
                String dataStr;
                if (value instanceof String) {
                    writer.write("\"");
                    CharEscapeUtil charEscapeUtil2 = new CharEscapeUtil(writer);
                    charEscapeUtil2.writeString((String)value, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof java.util.Date) {
                    DateFormateMeta dateFormateMeta;
                    DateFormat dateFormat = null;
                    if (fieldMeta != null && (dateFormateMeta = fieldMeta.getDateFormateMeta()) != null) {
                        dateFormat = dateFormateMeta.toDateFormat();
                    }
                    if (dateFormat == null) {
                        dateFormat = esjdbc.getFormat();
                    }
                    String dataStr2 = ESUtil.getDate((java.util.Date)((java.util.Date)value), (DateFormat)dateFormat);
                    writer.write("\"");
                    writer.write(dataStr2);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Clob) {
                    dataStr = ValueExchange.getStringFromClob((Clob)((Clob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                if (value instanceof Blob) {
                    dataStr = ValueExchange.getStringFromBlob((Blob)((Blob)value));
                    writer.write("\"");
                    charEscapeUtil = new CharEscapeUtil(writer);
                    charEscapeUtil.writeString(dataStr, true);
                    writer.write("\"");
                    continue;
                }
                writer.write(String.valueOf(value));
                continue;
            }
            writer.write("null");
        }
        writer.write("}\n");
    }

    @Override
    public ClientInterface getClientInterface() {
        return this.clientInterface;
    }

    @Override
    public ESJDBC getESJDBC() {
        return this.jdbcResultSet;
    }
}

