/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DisableMetricsCollectionRequestMarshaller
implements Marshaller<Request<DisableMetricsCollectionRequest>, DisableMetricsCollectionRequest> {
    public Request<DisableMetricsCollectionRequest> marshall(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        if (disableMetricsCollectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disableMetricsCollectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DisableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (disableMetricsCollectionRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)disableMetricsCollectionRequest.getAutoScalingGroupName()));
        }
        if (!disableMetricsCollectionRequest.getMetrics().isEmpty() || !((SdkInternalList)disableMetricsCollectionRequest.getMetrics()).isAutoConstruct()) {
            SdkInternalList metricsList = (SdkInternalList)disableMetricsCollectionRequest.getMetrics();
            int metricsListIndex = 1;
            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString((String)metricsListValue));
                }
                ++metricsListIndex;
            }
        }
        return request;
    }
}

