/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.properties.config;

import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.alibaba.nacos.api.config.annotation.NacosIgnore;
import com.alibaba.nacos.api.config.annotation.NacosProperty;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.beans.factory.annotation.ConfigServiceBeanBuilder;
import com.alibaba.nacos.spring.context.event.config.NacosConfigMetadataEvent;
import com.alibaba.nacos.spring.context.event.config.NacosConfigurationPropertiesBeanBoundEvent;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

class NacosConfigurationPropertiesBinder {
    private static final Logger logger = LoggerFactory.getLogger(NacosConfigurationPropertiesBinder.class);
    private final ConfigurableApplicationContext applicationContext;
    private final Environment environment;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ConfigServiceBeanBuilder configServiceBeanBuilder;

    NacosConfigurationPropertiesBinder(ConfigurableApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ConfigurableApplicationContext must not be null!");
        this.applicationContext = applicationContext;
        this.environment = applicationContext.getEnvironment();
        this.applicationEventPublisher = applicationContext;
        this.configServiceBeanBuilder = NacosBeanUtils.getConfigServiceBeanBuilder((BeanFactory)applicationContext);
    }

    protected void bind(Object bean, String beanName) {
        NacosConfigurationProperties properties = (NacosConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), NacosConfigurationProperties.class);
        this.bind(bean, beanName, properties);
    }

    protected void bind(final Object bean, final String beanName, final NacosConfigurationProperties properties) {
        String content;
        ConfigService configService;
        String groupId;
        String dataId;
        block4: {
            Assert.notNull((Object)bean, (String)"Bean must not be null!");
            Assert.notNull((Object)properties, (String)"NacosConfigurationProperties must not be null!");
            dataId = properties.dataId();
            groupId = properties.groupId();
            configService = (ConfigService)this.configServiceBeanBuilder.build(properties.properties());
            if (properties.autoRefreshed()) {
                try {
                    configService.addListener(dataId, groupId, (Listener)new AbstractListener(){

                        public void receiveConfigInfo(String config) {
                            NacosConfigurationPropertiesBinder.this.doBind(bean, beanName, dataId, groupId, properties, config, configService);
                        }
                    });
                }
                catch (NacosException e) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (StringUtils.hasText((String)(content = NacosUtils.getContent(configService, dataId, groupId)))) {
            this.doBind(bean, beanName, dataId, groupId, properties, content, configService);
        }
    }

    private void doBind(Object bean, String beanName, String dataId, String groupId, NacosConfigurationProperties properties, String content, ConfigService configService) {
        PropertyValues propertyValues = this.resolvePropertyValues(bean, content);
        this.doBind(bean, properties, propertyValues);
        this.publishBoundEvent(bean, beanName, dataId, groupId, properties, content, configService);
        this.publishMetadataEvent(bean, beanName, dataId, groupId, properties);
    }

    private void publishMetadataEvent(Object bean, String beanName, String dataId, String groupId, NacosConfigurationProperties properties) {
        NacosProperties nacosProperties = properties.properties();
        NacosConfigMetadataEvent metadataEvent = new NacosConfigMetadataEvent(properties);
        metadataEvent.setDataId(dataId);
        metadataEvent.setGroupId(groupId);
        Properties resolvedNacosProperties = this.configServiceBeanBuilder.resolveProperties(nacosProperties);
        Map nacosPropertiesAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)nacosProperties);
        metadataEvent.setNacosPropertiesAttributes(nacosPropertiesAttributes);
        metadataEvent.setNacosProperties(resolvedNacosProperties);
        Class<?> beanClass = bean.getClass();
        metadataEvent.setBeanName(beanName);
        metadataEvent.setBean(bean);
        metadataEvent.setBeanType(beanClass);
        metadataEvent.setAnnotatedElement(beanClass);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)metadataEvent);
    }

    private void publishBoundEvent(Object bean, String beanName, String dataId, String groupId, NacosConfigurationProperties properties, String content, ConfigService configService) {
        NacosConfigurationPropertiesBeanBoundEvent event = new NacosConfigurationPropertiesBeanBoundEvent(configService, dataId, groupId, bean, beanName, properties, content);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }

    private void doBind(Object bean, NacosConfigurationProperties properties, PropertyValues propertyValues) {
        DataBinder dataBinder = new DataBinder(bean);
        dataBinder.setAutoGrowNestedPaths(properties.ignoreNestedProperties());
        dataBinder.setIgnoreInvalidFields(properties.ignoreInvalidFields());
        dataBinder.setIgnoreUnknownFields(properties.ignoreUnknownFields());
        dataBinder.bind(propertyValues);
    }

    private PropertyValues resolvePropertyValues(Object bean, String content) {
        final Properties configProperties = NacosUtils.toProperties(content);
        final MutablePropertyValues propertyValues = new MutablePropertyValues();
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                String propertyName = NacosConfigurationPropertiesBinder.this.resolvePropertyName(field);
                if (StringUtils.hasText((String)propertyName) && configProperties.containsKey(propertyName)) {
                    String propertyValue = configProperties.getProperty(propertyName);
                    propertyValues.add(field.getName(), (Object)propertyValue);
                }
            }
        });
        return propertyValues;
    }

    private String resolvePropertyName(Field field) {
        if (AnnotationUtils.getAnnotation((AnnotatedElement)field, NacosIgnore.class) != null) {
            return null;
        }
        NacosProperty nacosProperty = (NacosProperty)AnnotationUtils.getAnnotation((AnnotatedElement)field, NacosProperty.class);
        return nacosProperty != null ? nacosProperty.value() : field.getName();
    }
}

