/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.DruidStatManagerFacade;
import com.alibaba.druid.stat.DruidStatServiceMBean;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.support.spring.stat.SpringStatManager;
import com.alibaba.druid.util.MapComparator;
import com.alibaba.druid.util.StringUtils;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class DruidStatService
implements DruidStatServiceMBean {
    private static final Log LOG = LogFactory.getLog(DruidStatService.class);
    public static final String MBEAN_NAME = "com.alibaba.druid:type=DruidStatService";
    private static final DruidStatService instance = new DruidStatService();
    private static DruidStatManagerFacade statManagerFacade = DruidStatManagerFacade.getInstance();
    public static final int RESULT_CODE_SUCCESS = 1;
    public static final int RESULT_CODE_ERROR = -1;
    private static final int DEFAULT_PAGE = 1;
    private static final int DEFAULT_PER_PAGE_COUNT = Integer.MAX_VALUE;
    private static final String ORDER_TYPE_DESC = "desc";
    private static final String ORDER_TYPE_ASC = "asc";
    private static final String DEFAULT_ORDER_TYPE = "asc";
    private static final String DEFAULT_ORDERBY = "SQL";

    private DruidStatService() {
    }

    public static DruidStatService getInstance() {
        return instance;
    }

    public boolean isResetEnable() {
        return statManagerFacade.isResetEnable();
    }

    public void setResetEnable(boolean value) {
        statManagerFacade.setResetEnable(value);
    }

    @Override
    public String service(String url) {
        Map<String, String> parameters = DruidStatService.getParameters(url);
        if (url.equals("/basic.json")) {
            return DruidStatService.returnJSONResult(1, statManagerFacade.returnJSONBasicStat());
        }
        if (url.equals("/reset-all.json")) {
            statManagerFacade.resetAll();
            return DruidStatService.returnJSONResult(1, null);
        }
        if (url.equals("/log-and-reset.json")) {
            statManagerFacade.logAndResetDataSource();
            return DruidStatService.returnJSONResult(1, null);
        }
        if (url.equals("/datasource.json")) {
            return DruidStatService.returnJSONResult(1, statManagerFacade.getDataSourceStatDataList());
        }
        if (url.equals("/activeConnectionStackTrace.json")) {
            return DruidStatService.returnJSONResult(1, statManagerFacade.getActiveConnStackTraceList());
        }
        if (url.startsWith("/datasource-")) {
            Integer id = StringUtils.subStringToInteger(url, "datasource-", ".");
            Map<String, Object> result = statManagerFacade.getDataSourceStatData(id);
            return DruidStatService.returnJSONResult(result == null ? -1 : 1, result);
        }
        if (url.startsWith("/connectionInfo-") && url.endsWith(".json")) {
            Integer id = StringUtils.subStringToInteger(url, "connectionInfo-", ".");
            List<Map<String, Object>> connectionInfoList = statManagerFacade.getPoolingConnectionInfoByDataSourceId(id);
            return DruidStatService.returnJSONResult(connectionInfoList == null ? -1 : 1, connectionInfoList);
        }
        if (url.startsWith("/activeConnectionStackTrace-") && url.endsWith(".json")) {
            Integer id = StringUtils.subStringToInteger(url, "activeConnectionStackTrace-", ".");
            return this.returnJSONActiveConnectionStackTrace(id);
        }
        if (url.startsWith("/sql.json")) {
            return DruidStatService.returnJSONResult(1, this.getSqlStatDataList(parameters));
        }
        if (url.startsWith("/wall.json")) {
            return DruidStatService.returnJSONResult(1, this.getWallStatMap(parameters));
        }
        if (url.startsWith("/wall-") && url.indexOf(".json") > 0) {
            Integer dataSourceId = StringUtils.subStringToInteger(url, "wall-", ".json");
            Map<String, Object> result = statManagerFacade.getWallStatMap(dataSourceId);
            return DruidStatService.returnJSONResult(result == null ? -1 : 1, result);
        }
        if (url.startsWith("/sql-") && url.indexOf(".json") > 0) {
            Integer id = StringUtils.subStringToInteger(url, "sql-", ".json");
            return this.getSqlStat(id);
        }
        if (url.startsWith("/weburi.json")) {
            return DruidStatService.returnJSONResult(1, this.getWebURIStatDataList(parameters));
        }
        if (url.startsWith("/weburi-") && url.indexOf(".json") > 0) {
            String uri = StringUtils.subString(url, "weburi-", ".json", true);
            return DruidStatService.returnJSONResult(1, this.getWebURIStatData(uri));
        }
        if (url.startsWith("/webapp.json")) {
            return DruidStatService.returnJSONResult(1, this.getWebAppStatDataList(parameters));
        }
        if (url.startsWith("/websession.json")) {
            return DruidStatService.returnJSONResult(1, this.getWebSessionStatDataList(parameters));
        }
        if (url.startsWith("/websession-") && url.indexOf(".json") > 0) {
            String id = StringUtils.subString(url, "websession-", ".json");
            return DruidStatService.returnJSONResult(1, this.getWebSessionStatData(id));
        }
        if (url.startsWith("/spring.json")) {
            return DruidStatService.returnJSONResult(1, this.getSpringStatDataList(parameters));
        }
        if (url.startsWith("/spring-detail.json")) {
            String clazz = parameters.get("class");
            String method = parameters.get("method");
            return DruidStatService.returnJSONResult(1, this.getSpringMethodStatData(clazz, method));
        }
        return DruidStatService.returnJSONResult(-1, "Do not support this request, please contact with administrator.");
    }

    private List<Map<String, Object>> getSpringStatDataList(Map<String, String> parameters) {
        List<Map<String, Object>> array = SpringStatManager.getInstance().getMethodStatData();
        return this.comparatorOrderBy(array, parameters);
    }

    private List<Map<String, Object>> getWebURIStatDataList(Map<String, String> parameters) {
        List<Map<String, Object>> array = WebAppStatManager.getInstance().getURIStatData();
        return this.comparatorOrderBy(array, parameters);
    }

    private Map<String, Object> getWebURIStatData(String uri) {
        return WebAppStatManager.getInstance().getURIStatData(uri);
    }

    private Map<String, Object> getWebSessionStatData(String sessionId) {
        return WebAppStatManager.getInstance().getSessionStat(sessionId);
    }

    private Map<String, Object> getSpringMethodStatData(String clazz, String method) {
        return SpringStatManager.getInstance().getMethodStatData(clazz, method);
    }

    private List<Map<String, Object>> getWebSessionStatDataList(Map<String, String> parameters) {
        List<Map<String, Object>> array = WebAppStatManager.getInstance().getSessionStatData();
        return this.comparatorOrderBy(array, parameters);
    }

    private List<Map<String, Object>> getWebAppStatDataList(Map<String, String> parameters) {
        List<Map<String, Object>> array = WebAppStatManager.getInstance().getWebAppStatData();
        return this.comparatorOrderBy(array, parameters);
    }

    private List<Map<String, Object>> comparatorOrderBy(List<Map<String, Object>> array, Map<String, String> parameters) {
        String orderBy;
        if (array == null || array.isEmpty()) {
            return null;
        }
        String orderType = null;
        Integer page = 1;
        Integer perPageCount = Integer.MAX_VALUE;
        if (parameters == null) {
            orderBy = DEFAULT_ORDERBY;
            orderType = "asc";
            page = 1;
            perPageCount = Integer.MAX_VALUE;
        } else {
            String pageCountParam;
            orderBy = parameters.get("orderBy");
            orderType = parameters.get("orderType");
            String pageParam = parameters.get("page");
            if (pageParam != null && pageParam.length() != 0) {
                page = Integer.parseInt(pageParam);
            }
            if ((pageCountParam = parameters.get("perPageCount")) != null && pageCountParam.length() > 0) {
                perPageCount = Integer.parseInt(pageCountParam);
            }
        }
        orderBy = orderBy == null ? DEFAULT_ORDERBY : orderBy;
        String string = orderType = orderType == null ? "asc" : orderType;
        if (!ORDER_TYPE_DESC.equals(orderType)) {
            orderType = "asc";
        }
        if (orderBy.trim().length() != 0) {
            Collections.sort(array, new MapComparator(orderBy, ORDER_TYPE_DESC.equals(orderType)));
        }
        int fromIndex = (page - 1) * perPageCount;
        int toIndex = page * perPageCount;
        if (toIndex > array.size()) {
            toIndex = array.size();
        }
        return array.subList(fromIndex, toIndex);
    }

    private List<Map<String, Object>> getSqlStatDataList(Map<String, String> parameters) {
        Integer dataSourceId = null;
        String dataSourceIdParam = parameters.get("dataSourceId");
        if (dataSourceIdParam != null && dataSourceIdParam.length() > 0) {
            dataSourceId = Integer.parseInt(dataSourceIdParam);
        }
        List<Map<String, Object>> array = statManagerFacade.getSqlStatDataList(dataSourceId);
        List<Map<String, Object>> sortedArray = this.comparatorOrderBy(array, parameters);
        return sortedArray;
    }

    public Map<String, Object> getWallStatMap(Map<String, String> parameters) {
        Map<String, Object> result;
        Integer dataSourceId = null;
        String dataSourceIdParam = parameters.get("dataSourceId");
        if (dataSourceIdParam != null && dataSourceIdParam.length() > 0) {
            dataSourceId = Integer.parseInt(dataSourceIdParam);
        }
        if ((result = statManagerFacade.getWallStatMap(dataSourceId)) != null) {
            List functions;
            List tables = (List)result.get("tables");
            if (tables != null) {
                List<Map<String, Object>> sortedArray = this.comparatorOrderBy(tables, parameters);
                result.put("tables", sortedArray);
            }
            if ((functions = (List)result.get("functions")) != null) {
                List<Map<String, Object>> sortedArray = this.comparatorOrderBy(functions, parameters);
                result.put("functions", sortedArray);
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private String getSqlStat(Integer id) {
        Map<String, Object> map = statManagerFacade.getSqlStatData(id);
        if (map == null) {
            return DruidStatService.returnJSONResult(-1, null);
        }
        DbType dbType = DbType.of((String)map.get("DbType"));
        String sql = (String)map.get(DEFAULT_ORDERBY);
        map.put("formattedSql", SQLUtils.format(sql, dbType));
        List<SQLStatement> statementList = SQLUtils.parseStatements(sql, dbType, new SQLParserFeature[0]);
        if (!statementList.isEmpty()) {
            SQLStatement sqlStmt = statementList.get(0);
            SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor(dbType);
            sqlStmt.accept(visitor);
            map.put("parsedTable", visitor.getTables().toString());
            map.put("parsedFields", visitor.getColumns().toString());
            map.put("parsedConditions", visitor.getConditions().toString());
            map.put("parsedRelationships", visitor.getRelationships().toString());
            map.put("parsedOrderbycolumns", visitor.getOrderByColumns().toString());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        Date maxTimespanOccurTime = (Date)map.get("MaxTimespanOccurTime");
        if (maxTimespanOccurTime != null) {
            map.put("MaxTimespanOccurTime", format.format(maxTimespanOccurTime));
        }
        return DruidStatService.returnJSONResult(map == null ? -1 : 1, map);
    }

    private String returnJSONActiveConnectionStackTrace(Integer id) {
        List<String> result = statManagerFacade.getActiveConnectionStackTraceByDataSourceId(id);
        if (result == null) {
            return DruidStatService.returnJSONResult(-1, "require set removeAbandoned=true");
        }
        return DruidStatService.returnJSONResult(1, result);
    }

    public static String returnJSONResult(int resultCode, Object content) {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("ResultCode", resultCode);
        dataMap.put("Content", content);
        return JSONUtils.toJSONString(dataMap);
    }

    public static void registerMBean() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName(MBEAN_NAME);
            if (!mbeanServer.isRegistered(objectName)) {
                mbeanServer.registerMBean(instance, objectName);
            }
        }
        catch (JMException ex) {
            LOG.error("register mbean error", ex);
        }
    }

    public static void unregisterMBean() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mbeanServer.unregisterMBean(new ObjectName(MBEAN_NAME));
        }
        catch (JMException ex) {
            LOG.error("unregister mbean error", ex);
        }
    }

    public static Map<String, String> getParameters(String url) {
        if (url == null || (url = url.trim()).length() == 0) {
            return Collections.emptyMap();
        }
        String parametersStr = StringUtils.subString(url, "?", null);
        if (parametersStr == null || parametersStr.length() == 0) {
            return Collections.emptyMap();
        }
        String[] parametersArray = parametersStr.split("&");
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (String parameterStr : parametersArray) {
            int index = parameterStr.indexOf("=");
            if (index <= 0) continue;
            String name = parameterStr.substring(0, index);
            String value = parameterStr.substring(index + 1);
            parameters.put(name, value);
        }
        return parameters;
    }
}

