/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SQLSelectListCache {
    private final String dbType;
    private List<String> sqlCache = new CopyOnWriteArrayList<String>();
    private List<SQLSelectQueryBlock> queryBlockCache = new CopyOnWriteArrayList<SQLSelectQueryBlock>();
    private List<String> printSqlList = new ArrayList<String>();

    public SQLSelectListCache(String dbType) {
        this.dbType = dbType;
    }

    public void add(String select) {
        if (select == null || select.length() == 0) {
            return;
        }
        SQLSelectParser selectParser = SQLParserUtils.createSQLStatementParser(select, this.dbType).createSQLSelectParser();
        SQLSelectQueryBlock queryBlock = SQLParserUtils.createSelectQueryBlock(this.dbType);
        selectParser.accept(Token.SELECT);
        selectParser.parseSelectList(queryBlock);
        selectParser.accept(Token.FROM);
        selectParser.accept(Token.EOF);
        this.sqlCache.add(select.substring(6));
        this.queryBlockCache.add(queryBlock);
        this.printSqlList.add(queryBlock.toString());
    }

    public boolean match(Lexer lexer, SQLSelectQueryBlock queryBlock) {
        if (lexer.token != Token.SELECT) {
            return false;
        }
        int pos = lexer.pos;
        String text = lexer.text;
        for (int i = 0; i < this.sqlCache.size(); ++i) {
            String block = this.sqlCache.get(i);
            if (!text.startsWith(block, pos)) continue;
            String printSql = this.printSqlList.get(i);
            queryBlock.setCachedSelectList(printSql);
            int len = pos + block.length();
            lexer.reset(len, text.charAt(len), Token.FROM);
            return true;
        }
        return false;
    }
}

