/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.AbstractPropertySourceLoader;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NacosXmlPropertySourceLoader
extends AbstractPropertySourceLoader
implements Ordered {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    protected List<PropertySource<?>> doLoad(String name, Resource resource) throws IOException {
        Map<String, Object> nacosDataMap = this.parseXml2Map(resource);
        return Collections.singletonList(new OriginTrackedMapPropertySource(name, nacosDataMap, true));
    }

    private Map<String, Object> parseXml2Map(Resource resource) throws IOException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(32);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(resource.getInputStream());
            if (null == document) {
                return null;
            }
            this.parseNodeList(document.getChildNodes(), map, "");
        }
        catch (Exception e) {
            throw new IOException("The xml content parse error.", e.getCause());
        }
        return map;
    }

    private void parseNodeList(NodeList nodeList, Map<String, Object> map, String parentKey) {
        if (nodeList == null || nodeList.getLength() < 1) {
            return;
        }
        parentKey = parentKey == null ? "" : parentKey;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String value = node.getNodeValue();
            value = value == null ? "" : value.trim();
            String name = node.getNodeName();
            String string = name = name == null ? "" : name.trim();
            if (StringUtils.isEmpty((Object)name)) continue;
            String key = StringUtils.isEmpty((Object)parentKey) ? name : parentKey + "." + name;
            NamedNodeMap nodeMap = node.getAttributes();
            this.parseNodeAttr(nodeMap, map, key);
            if (node.getNodeType() == 1 && node.hasChildNodes()) {
                this.parseNodeList(node.getChildNodes(), map, key);
                continue;
            }
            if (value.length() < 1) continue;
            map.put(parentKey, value);
        }
    }

    private void parseNodeAttr(NamedNodeMap nodeMap, Map<String, Object> map, String parentKey) {
        if (null == nodeMap || nodeMap.getLength() < 1) {
            return;
        }
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node node = nodeMap.item(i);
            if (null == node || node.getNodeType() != 2 || StringUtils.isEmpty((Object)node.getNodeName()) || StringUtils.isEmpty((Object)node.getNodeValue())) continue;
            map.put(String.join((CharSequence)".", parentKey, node.getNodeName()), node.getNodeValue());
        }
    }
}

