/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class AndroidNotification
extends PlatformNotification {
    public static final String NOTIFICATION_ANDROID = "android";
    private static final String TITLE = "title";
    private static final String BUILDER_ID = "builder_id";
    private static final String CHANNEL_ID = "channel_id";
    private static final String PRIORITY = "priority";
    private static final String CATEGORY = "category";
    private static final String STYLE = "style";
    private static final String ALERT_TYPE = "alert_type";
    private static final String BIG_TEXT = "big_text";
    private static final String INBOX = "inbox";
    private static final String BIG_PIC_PATH = "big_pic_path";
    private static final String LARGE_ICON = "large_icon";
    private static final String SMALL_ICON_URI = "small_icon_uri";
    private static final String INTENT = "intent";
    private static final String URI_ACTIVITY = "uri_activity";
    private static final String URI_ACTION = "uri_action";
    private static final String BADGE_ADD_NUM = "badge_add_num";
    private static final String BADGE_CLASS = "badge_class";
    private static final String SOUND = "sound";
    private static final String SHOW_BEGIN_TIME = "show_begin_time";
    private static final String SHOW_END_TIME = "show_end_time";
    private static final String DISPLAY_FOREGROUND = "display_foreground";
    private final String title;
    private final int builderId;
    private String channelId;
    private int priority;
    private String category;
    private int style = 0;
    private int alert_type;
    private String big_text;
    private Object inbox;
    private String big_pic_path;
    private String large_icon;
    private String small_icon_uri;
    private JsonObject intent;
    private String uri_activity;
    private String uri_action;
    private int badge_add_num;
    private String badge_class;
    private String sound;
    private String show_begin_time;
    private String show_end_time;
    private String display_foreground;

    private AndroidNotification(Object alert, String title, int builderId, String channelId, int priority, String category, int style, int alertType, String bigText, Object inbox, String bigPicPath, String large_icon, String small_icon_uri, JsonObject intent, String uri_activity, String uri_action, int badge_add_num, String badge_class, String sound, String show_begin_time, String show_end_time, String display_foreground, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras, Map<String, JsonPrimitive> customData) {
        super(alert, extras, numberExtras, booleanExtras, jsonExtras, customData);
        this.title = title;
        this.builderId = builderId;
        this.channelId = channelId;
        this.priority = priority;
        this.category = category;
        this.style = style;
        this.alert_type = alertType;
        this.big_text = bigText;
        this.inbox = inbox;
        this.big_pic_path = bigPicPath;
        this.large_icon = large_icon;
        this.small_icon_uri = small_icon_uri;
        this.intent = intent;
        this.uri_activity = uri_activity;
        this.uri_action = uri_action;
        this.badge_add_num = badge_add_num;
        this.badge_class = badge_class;
        this.sound = sound;
        this.show_begin_time = show_begin_time;
        this.show_end_time = show_end_time;
        this.display_foreground = display_foreground;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AndroidNotification alert(String alert) {
        return AndroidNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_ANDROID;
    }

    protected Object getInbox() {
        return this.inbox;
    }

    protected void setInbox(Object inbox) {
        this.inbox = inbox;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (this.builderId > 0) {
            json.add(BUILDER_ID, (JsonElement)new JsonPrimitive((Number)this.builderId));
        }
        if (null != this.channelId) {
            json.add(CHANNEL_ID, (JsonElement)new JsonPrimitive(this.channelId));
        }
        if (0 != this.priority) {
            json.add(PRIORITY, (JsonElement)new JsonPrimitive((Number)this.priority));
        }
        if (null != this.category) {
            json.add(CATEGORY, (JsonElement)new JsonPrimitive(this.category));
        }
        if (0 != this.style) {
            json.add(STYLE, (JsonElement)new JsonPrimitive((Number)this.style));
        }
        if (-1 != this.alert_type) {
            json.add(ALERT_TYPE, (JsonElement)new JsonPrimitive((Number)this.alert_type));
        }
        if (null != this.big_text) {
            json.add(BIG_TEXT, (JsonElement)new JsonPrimitive(this.big_text));
        }
        if (null != this.inbox && this.inbox instanceof JsonObject) {
            json.add(INBOX, (JsonElement)((JsonObject)this.inbox));
        }
        if (null != this.big_pic_path) {
            json.add(BIG_PIC_PATH, (JsonElement)new JsonPrimitive(this.big_pic_path));
        }
        if (null != this.large_icon) {
            json.add(LARGE_ICON, (JsonElement)new JsonPrimitive(this.large_icon));
        }
        if (null != this.small_icon_uri) {
            json.add(SMALL_ICON_URI, (JsonElement)new JsonPrimitive(this.small_icon_uri));
        }
        if (null != this.intent) {
            json.add(INTENT, (JsonElement)this.intent);
        }
        if (null != this.uri_activity) {
            json.add(URI_ACTIVITY, (JsonElement)new JsonPrimitive(this.uri_activity));
        }
        if (null != this.uri_action) {
            json.add(URI_ACTION, (JsonElement)new JsonPrimitive(this.uri_action));
        }
        if (0 != this.badge_add_num) {
            json.add(BADGE_ADD_NUM, (JsonElement)new JsonPrimitive((Number)this.badge_add_num));
        }
        if (null != this.badge_class) {
            json.add(BADGE_CLASS, (JsonElement)new JsonPrimitive(this.badge_class));
        }
        if (null != this.sound) {
            json.add(SOUND, (JsonElement)new JsonPrimitive(this.sound));
        }
        if (null != this.show_begin_time) {
            json.add(SHOW_BEGIN_TIME, (JsonElement)new JsonPrimitive(this.show_begin_time));
        }
        if (null != this.show_end_time) {
            json.add(SHOW_END_TIME, (JsonElement)new JsonPrimitive(this.show_end_time));
        }
        if (null != this.display_foreground) {
            json.add(DISPLAY_FOREGROUND, (JsonElement)new JsonPrimitive(this.display_foreground));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<AndroidNotification, Builder> {
        private String title;
        private int builderId;
        private String channelId;
        private int priority;
        private String category;
        private int style = 0;
        private int alert_type = -1;
        private String big_text;
        private Object inbox;
        private String big_pic_path;
        private String large_icon;
        private String small_icon_uri;
        private JsonObject intent;
        private String uri_activity;
        private String uri_action;
        private int badge_add_num;
        private String badge_class;
        private String sound;
        private String show_begin_time;
        private String show_end_time;
        private String display_foreground;

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder setAlert(Object alert) {
            this.alert = alert;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBuilderId(int builderId) {
            this.builderId = builderId;
            return this;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setStyle(int style) {
            this.style = style;
            return this;
        }

        public Builder setAlertType(int alertType) {
            this.alert_type = alertType;
            return this;
        }

        public Builder setBigText(String bigText) {
            this.big_text = bigText;
            return this;
        }

        public Builder setInbox(Object inbox) {
            if (null == inbox) {
                PlatformNotification.LOG.warn("Null inbox. Throw away it.");
                return this;
            }
            this.inbox = inbox;
            return this;
        }

        public Builder setBigPicPath(String bigPicPath) {
            this.big_pic_path = bigPicPath;
            return this;
        }

        public Builder setLargeIcon(String largeIcon) {
            this.large_icon = largeIcon;
            return this;
        }

        public Builder setSmallIconUri(String smallIconUri) {
            this.small_icon_uri = smallIconUri;
            return this;
        }

        public Builder setIntent(JsonObject intent) {
            if (null == intent) {
                PlatformNotification.LOG.warn("Null intent. Throw away it.");
                return this;
            }
            this.intent = intent;
            return this;
        }

        public Builder setUriActivity(String uriActivity) {
            this.uri_activity = uriActivity;
            return this;
        }

        public Builder setUriAction(String uriAction) {
            this.uri_action = uriAction;
            return this;
        }

        public Builder setBadgeAddNum(int badgeAddNum) {
            this.badge_add_num = badgeAddNum;
            return this;
        }

        public Builder setBadgeClass(String badgeClass) {
            this.badge_class = badgeClass;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setShowBeginTime(String showBeginTime) {
            this.show_begin_time = showBeginTime;
            return this;
        }

        public Builder setShowEndTime(String showEndTime) {
            this.show_end_time = showEndTime;
            return this;
        }

        public Builder setDisplayForeground(String displayForeground) {
            this.display_foreground = displayForeground;
            return this;
        }

        @Override
        public AndroidNotification build() {
            return new AndroidNotification(this.alert, this.title, this.builderId, this.channelId, this.priority, this.category, this.style, this.alert_type, this.big_text, this.inbox, this.big_pic_path, this.large_icon, this.small_icon_uri, this.intent, this.uri_activity, this.uri_action, this.badge_add_num, this.badge_class, this.sound, this.show_begin_time, this.show_end_time, this.display_foreground, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder, this.customData);
        }
    }
}

