/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.producer;

import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQProperties;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.MessageKeyBuilder;
import cn.bizvane.rocketmq.spring.core.producer.stat.RocketMQSendStats;
import cn.bizvane.rocketmq.spring.exception.MessageSendException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.google.common.base.Strings;
import java.util.UUID;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RocketMQTemplate {
    private Logger logger = LoggerFactory.getLogger((String)"cn.bizvane.rocketmq.template");
    private MQProducer producer;
    RocketMQProperties.Producer producerProperties;
    private MessageQueueSelector messageQueueSelector = new SelectMessageQueueByHash();
    private MessageKeyBuilder messageKeyBuilder = () -> UUID.randomUUID().toString();
    private RocketMQSendStats sendStats;

    public RocketMQTemplate(MQProducer producer, RocketMQProperties.Producer producerProperties, RocketMQSendStats sendStats) {
        this.producer = producer;
        this.producerProperties = producerProperties;
        this.sendStats = sendStats;
    }

    public SendResult send(Destination destination, Object body) {
        return this.send(destination, body, this.messageKeyBuilder.build());
    }

    public SendResult send(Destination destination, Object body, String msgKey) {
        return this.syncSend(destination, body, msgKey, this.messageQueueSelector, null);
    }

    public SendResult send(Destination destination, Object body, String msgKey, String hashValue) {
        return this.syncSend(destination, body, msgKey, this.messageQueueSelector, hashValue);
    }

    public SendResult send(Destination destination, Object body, MessageKeyBuilder messageKeyBuilder, String hashValue) {
        return this.syncSend(destination, body, messageKeyBuilder.build(), this.messageQueueSelector, hashValue);
    }

    public SendResult send(Destination destination, Object body, MessageQueueSelector messageQueueSelector, String hashValue) {
        return this.syncSend(destination, body, this.messageKeyBuilder.build(), messageQueueSelector, hashValue);
    }

    public SendResult send(Destination destination, Object body, MessageKeyBuilder messageKeyBuilder, MessageQueueSelector messageQueueSelector, String hashValue) {
        return this.syncSend(destination, body, messageKeyBuilder.build(), messageQueueSelector, hashValue);
    }

    public void asyncSend(Destination destination, Object body) {
        this.asyncSend(destination, body, this.messageKeyBuilder);
    }

    public void asyncSend(Destination destination, Object body, String msgKey) {
        this.asyncSend(destination, body, msgKey, this.messageQueueSelector, null);
    }

    public void asyncSend(Destination destination, Object body, MessageKeyBuilder messageKeyBuilder) {
        this.asyncSend(destination, body, messageKeyBuilder.build(), this.messageQueueSelector, null);
    }

    public void asyncSend(Destination destination, Object body, MessageKeyBuilder messageKeyBuilder, String hashValue) {
        this.asyncSend(destination, body, messageKeyBuilder.build(), this.messageQueueSelector, hashValue);
    }

    public void asyncSend(Destination destination, Object body, MessageKeyBuilder messageKeyBuilder, MessageQueueSelector messageQueueSelector, String hashValue) {
        this.asyncSend(destination, body, messageKeyBuilder.build(), messageQueueSelector, hashValue);
    }

    private Message buildMessage(Destination destination, Object body, String msgKey, MessageQueueSelector messageQueueSelector, String hashValue) {
        Assert.notNull((Object)destination, (String)"`destination` can not be empty`");
        Assert.notNull((Object)Strings.emptyToNull((String)destination.getTopic()), (String)"`destination.topic` can not be empty`");
        Assert.notNull((Object)body, (String)"`body` can not be null`");
        if (Strings.emptyToNull((String)hashValue) == null) {
            hashValue = msgKey;
        }
        Message message = new Message();
        message.setKeys(msgKey);
        message.setTopic(destination.getTopic());
        message.setTags(StringUtils.hasText((String)destination.getTag()) ? destination.getTag() : "*");
        message.setBuyerId(hashValue);
        message.setDelayTimeLevel(destination.getDelayLevel() != null ? destination.getDelayLevel().getLevel() : 0);
        byte[] bodyBytes = null;
        bodyBytes = body instanceof String ? body.toString().getBytes(IOUtils.UTF8) : JSON.toJSONBytes((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        message.setBody(bodyBytes);
        return message;
    }

    private void asyncSend(final Destination destination, final Object body, String msgKey, MessageQueueSelector messageQueueSelector, String hashValue) {
        final Message message = this.buildMessage(destination, body, msgKey, messageQueueSelector, hashValue);
        try {
            try {
                this.producer.send(message, messageQueueSelector, (Object)message.getBuyerId(), new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                        RocketMQTemplate.this.sendStats.success(destination);
                    }

                    public void onException(Throwable e) {
                        RocketMQTemplate.this.sendStats.fail(destination);
                        RocketMQTemplate.this.logger.error("\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5f02\u5e38, keys: {}, body: {}, buyerId:{}", new Object[]{message.getKeys(), JSON.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}), message.getBuyerId()});
                        RocketMQTemplate.this.logger.error("\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5931\u8d25", e);
                    }
                });
            }
            catch (Exception e) {
                this.sendStats.fail(destination);
                this.logger.error("\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5f02\u5e38, keys: {}, body: {}, buyerId:{}", new Object[]{message.getKeys(), JSON.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}), message.getBuyerId()});
                this.logger.error("\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5f02\u5e38", (Throwable)e);
                this.sendStats.total(destination);
            }
        }
        finally {
            this.sendStats.total(destination);
        }
    }

    private SendResult syncSend(Destination destination, Object body, String msgKey, MessageQueueSelector messageQueueSelector, String hashValue) {
        Message message = this.buildMessage(destination, body, msgKey, messageQueueSelector, hashValue);
        try {
            SendResult sendResult = this.producer.send(message, messageQueueSelector, (Object)message.getBuyerId());
            this.sendStats.success(destination);
            SendResult sendResult2 = sendResult;
            return sendResult2;
        }
        catch (Exception e) {
            this.sendStats.fail(destination);
            this.logger.error("\u540c\u6b65\u6d88\u606f\u53d1\u9001\u5f02\u5e38, keys: {}, body: {}, buyerId:{}", new Object[]{message.getKeys(), JSON.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField}), message.getBuyerId()});
            throw new MessageSendException("\u540c\u6b65\u6d88\u606f\u53d1\u9001\u5f02\u5e38", e);
        }
        finally {
            this.sendStats.total(destination);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MQProducer getProducer() {
        return this.producer;
    }

    public RocketMQProperties.Producer getProducerProperties() {
        return this.producerProperties;
    }

    public MessageQueueSelector getMessageQueueSelector() {
        return this.messageQueueSelector;
    }

    public MessageKeyBuilder getMessageKeyBuilder() {
        return this.messageKeyBuilder;
    }

    public RocketMQSendStats getSendStats() {
        return this.sendStats;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setProducer(MQProducer producer) {
        this.producer = producer;
    }

    public void setProducerProperties(RocketMQProperties.Producer producerProperties) {
        this.producerProperties = producerProperties;
    }

    public void setMessageQueueSelector(MessageQueueSelector messageQueueSelector) {
        this.messageQueueSelector = messageQueueSelector;
    }

    public void setMessageKeyBuilder(MessageKeyBuilder messageKeyBuilder) {
        this.messageKeyBuilder = messageKeyBuilder;
    }

    public void setSendStats(RocketMQSendStats sendStats) {
        this.sendStats = sendStats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocketMQTemplate)) {
            return false;
        }
        RocketMQTemplate other = (RocketMQTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        MQProducer this$producer = this.getProducer();
        MQProducer other$producer = other.getProducer();
        if (this$producer == null ? other$producer != null : !this$producer.equals(other$producer)) {
            return false;
        }
        RocketMQProperties.Producer this$producerProperties = this.getProducerProperties();
        RocketMQProperties.Producer other$producerProperties = other.getProducerProperties();
        if (this$producerProperties == null ? other$producerProperties != null : !((Object)this$producerProperties).equals(other$producerProperties)) {
            return false;
        }
        MessageQueueSelector this$messageQueueSelector = this.getMessageQueueSelector();
        MessageQueueSelector other$messageQueueSelector = other.getMessageQueueSelector();
        if (this$messageQueueSelector == null ? other$messageQueueSelector != null : !this$messageQueueSelector.equals(other$messageQueueSelector)) {
            return false;
        }
        MessageKeyBuilder this$messageKeyBuilder = this.getMessageKeyBuilder();
        MessageKeyBuilder other$messageKeyBuilder = other.getMessageKeyBuilder();
        if (this$messageKeyBuilder == null ? other$messageKeyBuilder != null : !this$messageKeyBuilder.equals(other$messageKeyBuilder)) {
            return false;
        }
        RocketMQSendStats this$sendStats = this.getSendStats();
        RocketMQSendStats other$sendStats = other.getSendStats();
        return !(this$sendStats == null ? other$sendStats != null : !this$sendStats.equals(other$sendStats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RocketMQTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        MQProducer $producer = this.getProducer();
        result = result * 59 + ($producer == null ? 43 : $producer.hashCode());
        RocketMQProperties.Producer $producerProperties = this.getProducerProperties();
        result = result * 59 + ($producerProperties == null ? 43 : ((Object)$producerProperties).hashCode());
        MessageQueueSelector $messageQueueSelector = this.getMessageQueueSelector();
        result = result * 59 + ($messageQueueSelector == null ? 43 : $messageQueueSelector.hashCode());
        MessageKeyBuilder $messageKeyBuilder = this.getMessageKeyBuilder();
        result = result * 59 + ($messageKeyBuilder == null ? 43 : $messageKeyBuilder.hashCode());
        RocketMQSendStats $sendStats = this.getSendStats();
        result = result * 59 + ($sendStats == null ? 43 : $sendStats.hashCode());
        return result;
    }

    public String toString() {
        return "RocketMQTemplate(logger=" + this.getLogger() + ", producer=" + this.getProducer() + ", producerProperties=" + this.getProducerProperties() + ", messageQueueSelector=" + this.getMessageQueueSelector() + ", messageKeyBuilder=" + this.getMessageKeyBuilder() + ", sendStats=" + this.getSendStats() + ")";
    }
}

