/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.core.consumer.AbstractMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.RetryStrategy;
import cn.bizvane.rocketmq.spring.exception.ConsumerListenerFindException;
import java.util.List;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListenerOrderlyImpl
extends AbstractMessageListener
implements MessageListenerOrderly {
    private static final Logger log = LoggerFactory.getLogger(MessageListenerOrderlyImpl.class);
    private RetryStrategy retryStrategy = RetryStrategy.RETRY_UNTIL_SUCCESS;

    public MessageListenerOrderlyImpl(RetryStrategy retryStrategy) {
        if (retryStrategy != null) {
            this.retryStrategy = retryStrategy;
        }
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        MessageExt messageExt = msgs.get(0);
        try {
            this.abstractConsumer.accept(messageExt);
            return ConsumeOrderlyStatus.SUCCESS;
        }
        catch (ConsumerListenerFindException e) {
            log.error("\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
            if (this.retryStrategy == RetryStrategy.RETRY_UNTIL_SUCCESS) {
                context.setAutoCommit(false);
                messageExt.setReconsumeTimes(-1);
            }
            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        }
    }
}

