/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ConsumerBeanDefinitionRegistry
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;
    private Environment environment;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        AnnotationTypeFilter annotationTypeFilter = new AnnotationTypeFilter(RocketMQMessageListener.class);
        scanner.addIncludeFilter((TypeFilter)annotationTypeFilter);
        Set<String> basePackages = this.getBasePackages(importingClassMetadata);
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(ClassUtils.getPackageName((String)basePackage));
            for (BeanDefinition beanDefinition : candidateComponents) {
                if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition bd = (AnnotatedBeanDefinition)beanDefinition;
                AnnotationMetadata annotationMetadata = bd.getMetadata();
                String alias = "RocketMQ-Consumer-" + annotationMetadata.getClassName();
                BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)bd, annotationMetadata.getClassName(), new String[]{alias});
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
            }
        }
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (beanDefinition.getMetadata().isIndependent()) {
                    if (beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().getInterfaceNames().length == 1 && Annotation.class.getName().equals(beanDefinition.getMetadata().getInterfaceNames()[0])) {
                        try {
                            Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)ConsumerBeanDefinitionRegistry.this.classLoader);
                            return !target.isAnnotation();
                        }
                        catch (Exception ex) {
                            this.logger.error((Object)("Could not load target class: " + beanDefinition.getMetadata().getClassName()), (Throwable)ex);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        String pkg;
        Map attributes = importingClassMetadata.getAnnotationAttributes(ComponentScan.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        Object[] objectArray = (String[])attributes.get("value");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            pkg = objectArray[n2];
            if (StringUtils.hasText((String)pkg)) {
                basePackages.add(pkg);
            }
            ++n2;
        }
        objectArray = (String[])attributes.get("basePackages");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            pkg = objectArray[n2];
            if (StringUtils.hasText((String)pkg)) {
                basePackages.add(pkg);
            }
            ++n2;
        }
        objectArray = (Class[])attributes.get("basePackageClasses");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object clazz = objectArray[n2];
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
            ++n2;
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }
}

