/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQProperties;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumeMode;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerBean;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.exception.ConsumerRegisterException;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class ConsumerAnnotationBean
implements InitializingBean,
ConsumerBean {
    private static final Logger log = LoggerFactory.getLogger(ConsumerAnnotationBean.class);
    DefaultMQPushConsumer consumer = null;
    private RocketMQProperties properties;
    private ApplicationContext ctx;
    private MessageListenerOrderly listenerOrderly;
    private MessageListenerConcurrently listenerConcurrently;
    private boolean running;
    final String SUBSCRIBE_SPLITTER = " || ";

    public ConsumerAnnotationBean(RocketMQProperties properties, ApplicationContext ctx, MessageListenerOrderly listenerOrderly, MessageListenerConcurrently listenerConcurrently) {
        this.properties = properties;
        this.ctx = ctx;
        this.listenerOrderly = listenerOrderly;
        this.listenerConcurrently = listenerConcurrently;
    }

    private void initConsumer() {
        RocketMQProperties.Consumer consumerProperty = this.properties.getConsumer();
        String consumerGroup = consumerProperty.getGroupName();
        if (!StringUtils.hasText((String)consumerGroup)) {
            throw new ConsumerRegisterException("consumerGroup empty.");
        }
        Map beansOfType = this.ctx.getBeansOfType(RocketMQListener.class);
        for (Map.Entry entry : beansOfType.entrySet()) {
            RocketMQMessageListener annoML;
            RocketMQListener listener = (RocketMQListener)entry.getValue();
            Class cls = listener.getClass();
            if (AopUtils.isAopProxy((Object)listener)) {
                cls = AopProxyUtils.ultimateTargetClass((Object)listener);
            }
            if ((annoML = cls.getAnnotation(RocketMQMessageListener.class)) == null) {
                throw new ConsumerRegisterException(String.format("class:%s \u6ca1\u6709\u6ce8\u89e3 @RocketMQMessageListener", cls.getName()));
            }
            String topic = annoML.topic();
            if (!StringUtils.hasText((String)topic)) {
                throw new ConsumerRegisterException("topic empty.");
            }
            Map tagMQListenerMap = (Map)subscriptionTable.get(topic);
            if (tagMQListenerMap == null) {
                tagMQListenerMap = Maps.newHashMap();
                subscriptionTable.put(topic, tagMQListenerMap);
            }
            for (String tag : annoML.tags()) {
                if (tagMQListenerMap.containsKey(tag)) {
                    throw new ConsumerRegisterException(String.format("\u91cd\u590d\u7684tag\u76d1\u542c, %s:%s", topic, tag));
                }
                tagMQListenerMap.put(tag, listener);
            }
        }
        this.consumer = new DefaultMQPushConsumer(StringUtils.hasText((String)this.properties.getAccessKey()) && StringUtils.hasText((String)this.properties.getSecretKey()) ? new AclClientRPCHook(new SessionCredentials(this.properties.getAccessKey(), this.properties.getSecretKey())) : null);
        if (this.properties.isNamespaceEnable()) {
            this.consumer.setNamespace(this.properties.getNamespace().toString());
        }
        this.consumer.setNamesrvAddr(this.properties.getNameServer());
        this.consumer.setConsumerGroup(consumerGroup);
        this.consumer.setMaxReconsumeTimes(consumerProperty.getMaxRetryCount());
        this.consumer.setConsumeTimeout(consumerProperty.getTimeout());
        this.consumer.setConsumeFromWhere(consumerProperty.getConsumeFromWhere());
        this.consumer.setUnitMode(true);
        this.consumer.setUnitName(consumerGroup);
        this.consumer.setConsumeMessageBatchMaxSize(1);
        if (consumerProperty.getConsumeMode() == ConsumeMode.CONCURRENTLY) {
            this.consumer.setMessageListener((MessageListener)this.listenerConcurrently);
            this.consumer.setConsumeThreadMin(consumerProperty.getMaxThread());
            this.consumer.setConsumeThreadMax(consumerProperty.getMaxThread());
        } else {
            this.consumer.setMessageListener((MessageListener)this.listenerOrderly);
            this.consumer.setSuspendCurrentQueueTimeMillis((long)consumerProperty.getSuspendCurrentQueueTimeMillis());
        }
        if (consumerProperty.getPullBatchSize() > 0) {
            this.consumer.setPullBatchSize(consumerProperty.getPullBatchSize());
        }
        if (consumerProperty.getQueueCacheCount() > 0) {
            this.consumer.setPullThresholdForQueue(consumerProperty.getQueueCacheCount());
        }
        if (consumerProperty.getTopicCacheCount() > 0) {
            this.consumer.setPullThresholdForTopic(consumerProperty.getTopicCacheCount());
        }
        if (consumerProperty.getConsumeFromWhere() == ConsumeFromWhere.CONSUME_FROM_TIMESTAMP) {
            if (StringUtils.hasText((String)consumerProperty.getConsumeTimestamp()) && consumerProperty.getConsumeTimestamp().length() != 14) {
                throw new ConsumerRegisterException("consumeTimestamp \u683c\u5f0f\u4e0d\u6b63\u786e.");
            }
            this.consumer.setConsumeTimestamp(consumerProperty.getConsumeTimestamp());
        }
        for (Map.Entry<Object, Object> entry : this.getSubscriptionTable().entrySet()) {
            String topic = (String)entry.getKey();
            String tags = Joiner.on((String)" || ").join(((Map)entry.getValue()).keySet());
            try {
                this.consumer.subscribe(topic, tags.contains("*") ? "*" : tags);
                log.info("ConsumerGroup:{} \u8ba2\u9605 topic: {} tags: {} ", new Object[]{consumerGroup, topic, tags});
            }
            catch (MQClientException e) {
                log.error("ConsumerGroup:{} \u8ba2\u9605topic: {}, tags: {} \u5931\u8d25", new Object[]{consumerGroup, topic, tags});
            }
        }
    }

    @Override
    public void start() {
        if (this.consumer != null && this.isClosed()) {
            try {
                log.info("Consumer in the start ....");
                this.consumer.start();
                log.info("Consumer start finish....");
                this.running = true;
            }
            catch (MQClientException e) {
                throw new IllegalStateException("Failed to start RocketMQ push consumer", e);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.consumer != null && this.isStarted()) {
            log.info("Consumer in the shutdown ....");
            this.consumer.shutdown();
            log.info("Consumer shutdown finish ....");
            this.running = false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    @Override
    public boolean isClosed() {
        return !this.running;
    }

    @Override
    public Map<String, Map<String, RocketMQListener>> getSubscriptionTable() {
        return subscriptionTable;
    }

    public void afterPropertiesSet() throws Exception {
        this.initConsumer();
    }
}

