/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQConsumerUtils;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import cn.bizvane.rocketmq.spring.exception.ConsumerListenerFindException;
import java.util.function.Consumer;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageListener.class);
    Consumer<MessageExt> messageDiff = AbstractMessageListener::messageDiff;
    Consumer<MessageExt> abstractConsumer = AbstractMessageListener::abstractConsumer;

    private static void messageDiff(MessageExt m) {
        String maxOffsetProperty = m.getProperty("MAX_OFFSET");
        if (maxOffsetProperty != null) {
            long maxOffset = Long.parseLong(maxOffsetProperty);
            long currentOffset = m.getQueueOffset();
            long diffOffset = maxOffset - currentOffset;
            log.info("topic:[{},{}], currentQueueId:{}, currentQueueOffset:{}, currentQueueMaxOffset:{}, diffOffset:{}", new Object[]{m.getTopic(), m.getTags(), m.getQueueId(), m.getQueueOffset(), maxOffset, diffOffset});
        }
    }

    private static void abstractConsumer(MessageExt m) {
        String tags;
        String topic = m.getTopic();
        RocketMQListener listener = RocketMQConsumerUtils.getListener(topic, tags = m.getTags());
        if (listener == null) {
            throw new ConsumerListenerFindException(String.format("topic: %s, tags: %s, listener\u4e0d\u5b58\u5728", topic, tags));
        }
        ConsumerMessage consumerMessage = RocketMQConsumerUtils.convertMessage(m, listener);
        listener.onMessage(consumerMessage);
    }
}

