/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisClusterConnection;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.StatefulRedisConnectionImpl;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.pubsub.RedisPubSubAsyncCommandsImpl;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import com.lambdaworks.redis.pubsub.RedisPubSubReactiveCommandsImpl;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.api.async.RedisPubSubAsyncCommands;
import com.lambdaworks.redis.pubsub.api.rx.RedisPubSubReactiveCommands;
import com.lambdaworks.redis.pubsub.api.sync.RedisPubSubCommands;
import io.netty.channel.ChannelHandler;
import io.netty.util.internal.ConcurrentSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class StatefulRedisPubSubConnectionImpl<K, V>
extends StatefulRedisConnectionImpl<K, V>
implements StatefulRedisPubSubConnection<K, V> {
    protected final List<RedisPubSubListener<K, V>> listeners = new CopyOnWriteArrayList<RedisPubSubListener<K, V>>();
    protected final Set<K> channels = new ConcurrentSet();
    protected final Set<K> patterns = new ConcurrentSet();

    public StatefulRedisPubSubConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, codec, timeout, unit);
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public RedisPubSubAsyncCommands<K, V> async() {
        return (RedisPubSubAsyncCommands)((Object)this.async);
    }

    @Override
    protected RedisPubSubAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisPubSubAsyncCommandsImpl(this, this.codec);
    }

    @Override
    public RedisPubSubCommands<K, V> sync() {
        return (RedisPubSubCommands)this.sync;
    }

    @Override
    protected RedisPubSubCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisPubSubCommands)this.syncHandler(this.async(), RedisConnection.class, RedisClusterConnection.class, RedisPubSubCommands.class);
    }

    @Override
    public RedisPubSubReactiveCommands<K, V> reactive() {
        return (RedisPubSubReactiveCommands)((Object)this.reactive);
    }

    @Override
    protected RedisPubSubReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisPubSubReactiveCommandsImpl(this, this.codec);
    }

    @Override
    public void channelRead(Object msg) {
        PubSubOutput output = (PubSubOutput)msg;
        if (output.type() == null || output.pattern() == null && output.channel() == null && output.get() == null) {
            return;
        }
        this.updateInternalState(output);
        this.notifyListeners(output);
    }

    @Override
    public void activated() {
        super.activated();
        this.resubscribe();
    }

    protected List<RedisFuture<Void>> resubscribe() {
        ArrayList<RedisFuture<Void>> result = new ArrayList<RedisFuture<Void>>();
        if (!this.channels.isEmpty()) {
            result.add(this.async().subscribe(this.toArray(this.channels)));
        }
        if (!this.patterns.isEmpty()) {
            result.add(this.async().psubscribe(this.toArray(this.patterns)));
        }
        return result;
    }

    protected void notifyListeners(PubSubOutput<K, V, V> output) {
        block8: for (RedisPubSubListener redisPubSubListener : this.listeners) {
            switch (output.type()) {
                case message: {
                    redisPubSubListener.message(output.channel(), output.get());
                    continue block8;
                }
                case pmessage: {
                    redisPubSubListener.message(output.pattern(), output.channel(), output.get());
                    continue block8;
                }
                case psubscribe: {
                    redisPubSubListener.psubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case punsubscribe: {
                    redisPubSubListener.punsubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case subscribe: {
                    redisPubSubListener.subscribed(output.channel(), output.count());
                    continue block8;
                }
                case unsubscribe: {
                    redisPubSubListener.unsubscribed(output.channel(), output.count());
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Operation " + (Object)((Object)output.type()) + " not supported");
        }
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }

    private void updateInternalState(PubSubOutput<K, V, V> output) {
        switch (output.type()) {
            case psubscribe: {
                this.patterns.add(output.pattern());
                break;
            }
            case punsubscribe: {
                this.patterns.remove(output.pattern());
                break;
            }
            case subscribe: {
                this.channels.add(output.channel());
                break;
            }
            case unsubscribe: {
                this.channels.remove(output.channel());
                break;
            }
        }
    }
}

