/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.internal;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.internal.LettuceAssert;

public class HostAndPort {
    private static final int NO_PORT = -1;
    public final String hostText;
    public final int port;

    private HostAndPort(String hostText, int port) {
        LettuceAssert.notNull(hostText, "HostText must not be null");
        this.hostText = hostText;
        this.port = port;
    }

    public static HostAndPort of(String host, int port) {
        LettuceAssert.isTrue(HostAndPort.isValidPort(port), String.format("Port out of range: %s", port));
        HostAndPort parsedHost = HostAndPort.parse(host);
        LettuceAssert.isTrue(!parsedHost.hasPort(), String.format("Host has a port: %s", host));
        return new HostAndPort(host, port);
    }

    public static HostAndPort parse(String hostPortString) {
        String host;
        LettuceAssert.notNull(hostPortString, "HostPortString must not be null");
        String portString = null;
        if (hostPortString.startsWith("[")) {
            String[] hostAndPort = HostAndPort.getHostAndPortFromBracketedHost(hostPortString);
            host = hostAndPort[0];
            portString = hostAndPort[1];
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
            }
        }
        int port = -1;
        if (!LettuceStrings.isEmpty(portString)) {
            LettuceAssert.isTrue(!portString.startsWith("+"), String.format("Unparseable port number: %s", hostPortString));
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Unparseable port number: %s" + hostPortString, new Object[0]));
            }
            LettuceAssert.isTrue(HostAndPort.isValidPort(port), String.format("Port number out of range: %s", hostPortString));
        }
        return new HostAndPort(host, port);
    }

    public static HostAndPort parseCompat(String hostAndPortPart) {
        int firstColonIndex = hostAndPortPart.indexOf(58);
        int lastColonIndex = hostAndPortPart.lastIndexOf(58);
        int bracketIndex = hostAndPortPart.lastIndexOf(93);
        if (firstColonIndex != lastColonIndex && lastColonIndex != -1 && bracketIndex == -1) {
            String hostPart = hostAndPortPart.substring(0, lastColonIndex);
            String portPart = hostAndPortPart.substring(lastColonIndex + 1);
            return HostAndPort.of(hostPart, Integer.parseInt(portPart));
        }
        return HostAndPort.parse(hostAndPortPart);
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public String getHostText() {
        return this.hostText;
    }

    public int getPort() {
        if (!this.hasPort()) {
            throw new IllegalStateException("No port present.");
        }
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAndPort)) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        if (this.port != that.port) {
            return false;
        }
        return this.hostText != null ? this.hostText.equals(that.hostText) : that.hostText == null;
    }

    public int hashCode() {
        int result = this.hostText != null ? this.hostText.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    private static String[] getHostAndPortFromBracketedHost(String hostPortString) {
        LettuceAssert.isTrue(hostPortString.charAt(0) == '[', String.format("Bracketed host-port string must start with a bracket: %s", hostPortString));
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        LettuceAssert.isTrue(colonIndex > -1 && closeBracketIndex > colonIndex, String.format("Invalid bracketed host/port: ", hostPortString));
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            return new String[]{host, ""};
        }
        LettuceAssert.isTrue(hostPortString.charAt(closeBracketIndex + 1) == ':', "Only a colon may follow a close bracket: " + hostPortString);
        for (int i = closeBracketIndex + 2; i < hostPortString.length(); ++i) {
            LettuceAssert.isTrue(Character.isDigit(hostPortString.charAt(i)), String.format("Port must be numeric: %s", hostPortString));
        }
        return new String[]{host, hostPortString.substring(closeBracketIndex + 2)};
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hostText);
        if (this.hasPort()) {
            sb.append(':').append(this.port);
        }
        return sb.toString();
    }
}

