/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ConnectionFuture;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.AbstractClusterNodeConnectionFactory;
import com.lambdaworks.redis.cluster.AsyncClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterNodeConnectionFactory;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.cluster.SynchronizingClusterConnectionProvider;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.HostAndPort;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

class PooledClusterConnectionProvider<K, V>
implements ClusterConnectionProvider,
AsyncClusterConnectionProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledClusterConnectionProvider.class);
    private final Object stateLock = new Object();
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final CompletableFuture<StatefulRedisConnection<K, V>>[] writers = new CompletableFuture[16384];
    private final CompletableFuture<StatefulRedisConnection<K, V>>[][] readers = new CompletableFuture[16384][];
    private final RedisClusterClient redisClusterClient;
    private final ClusterNodeConnectionFactory<K, V> connectionFactory;
    private final RedisChannelWriter<K, V> clusterWriter;
    private final RedisCodec<K, V> redisCodec;
    private final SynchronizingClusterConnectionProvider<K, V> connectionProvider;
    private Partitions partitions;
    private boolean autoFlushCommands = true;
    private ReadFrom readFrom;

    public PooledClusterConnectionProvider(RedisClusterClient redisClusterClient, RedisChannelWriter<K, V> clusterWriter, RedisCodec<K, V> redisCodec) {
        this.redisCodec = redisCodec;
        this.redisClusterClient = redisClusterClient;
        this.clusterWriter = clusterWriter;
        this.connectionFactory = new NodeConnectionPostProcessor(this.getConnectionFactory(redisClusterClient));
        this.connectionProvider = new SynchronizingClusterConnectionProvider<K, V>(this.connectionFactory);
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, int slot) {
        try {
            return this.getConnectionAsync(intent, slot).get();
        }
        catch (RedisException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        catch (ExecutionException e) {
            throw new RedisException(e.getCause());
        }
        catch (RuntimeException e) {
            throw new RedisException(e);
        }
    }

    @Override
    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(ClusterConnectionProvider.Intent intent, int slot) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + slot + ")");
        }
        if (intent == ClusterConnectionProvider.Intent.READ && this.readFrom != null) {
            return this.getReadConnection(slot);
        }
        return this.getWriteConnection(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<StatefulRedisConnection<K, V>> getWriteConnection(int slot) {
        CompletableFuture<StatefulRedisConnection<K, V>> writer;
        Object object = this.stateLock;
        synchronized (object) {
            writer = this.writers[slot];
        }
        if (writer == null) {
            RedisClusterNode partition = this.partitions.getPartitionBySlot(slot);
            if (partition == null) {
                throw new RedisException("Cannot determine a partition for slot " + slot + " (Partitions: " + this.partitions + ")");
            }
            RedisURI uri = partition.getUri();
            ClusterNodeConnectionFactory.ConnectionKey key = new ClusterNodeConnectionFactory.ConnectionKey(ClusterConnectionProvider.Intent.WRITE, uri.getHost(), uri.getPort());
            return this.getConnectionAsync(key).thenApply(connection -> {
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.writers[slot] == null) {
                        this.writers[slot] = CompletableFuture.completedFuture(connection);
                    }
                }
                return connection;
            });
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<StatefulRedisConnection<K, V>> getReadConnection(int slot) {
        CompletableFuture[] readerCandidates;
        boolean cached = true;
        Object object = this.stateLock;
        synchronized (object) {
            readerCandidates = this.readers[slot];
        }
        if (readerCandidates == null) {
            RedisClusterNode master = this.partitions.getPartitionBySlot(slot);
            if (master == null) {
                throw new RedisException("Cannot determine a partition to read for slot " + slot + " (Partitions: " + this.partitions + ")");
            }
            final List<RedisNodeDescription> candidates2 = this.getReadCandidates(master);
            List<RedisNodeDescription> selection = this.readFrom.select(new ReadFrom.Nodes(){

                @Override
                public List<RedisNodeDescription> getNodes() {
                    return candidates2;
                }

                @Override
                public Iterator<RedisNodeDescription> iterator() {
                    return candidates2.iterator();
                }
            });
            if (selection.isEmpty()) {
                throw new RedisException("Cannot determine a partition to read for slot " + slot + " (Partitions: " + this.partitions + ") with setting " + this.readFrom);
            }
            readerCandidates = this.getReadFromConnections(selection);
            cached = false;
        }
        CompletableFuture[] selectedReaderCandidates = readerCandidates;
        if (cached) {
            return CompletableFuture.allOf(readerCandidates).thenCompose(v -> {
                for (CompletableFuture candidate : selectedReaderCandidates) {
                    if (!((StatefulRedisConnection)candidate.join()).isOpen()) continue;
                    return candidate;
                }
                return selectedReaderCandidates[0];
            });
        }
        CompletableFuture filteredReaderCandidates = new CompletableFuture();
        ((CompletableFuture)CompletableFuture.allOf(readerCandidates).thenApply(v -> selectedReaderCandidates)).whenComplete((candidates, throwable) -> {
            if (throwable == null) {
                filteredReaderCandidates.complete(this.getConnections((CompletableFuture<StatefulRedisConnection<K, V>>[])candidates));
                return;
            }
            StatefulRedisConnection<K, V>[] connections = this.getConnections(selectedReaderCandidates);
            if (connections.length == 0) {
                filteredReaderCandidates.completeExceptionally((Throwable)throwable);
                return;
            }
            filteredReaderCandidates.complete(connections);
        });
        return filteredReaderCandidates.thenApply(statefulRedisConnections -> {
            CompletableFuture[] toCache = new CompletableFuture[((StatefulRedisConnection[])statefulRedisConnections).length];
            for (int i = 0; i < toCache.length; ++i) {
                toCache[i] = CompletableFuture.completedFuture(statefulRedisConnections[i]);
            }
            StatefulRedisConnection[] statefulRedisConnectionArray = this.stateLock;
            synchronized (this.stateLock) {
                this.readers[slot] = toCache;
                // ** MonitorExit[var4_5] (shouldn't be in output)
                for (StatefulRedisConnection candidate : statefulRedisConnections) {
                    if (!candidate.isOpen()) continue;
                    return candidate;
                }
                return statefulRedisConnections[0];
            }
        });
    }

    private StatefulRedisConnection<K, V>[] getConnections(CompletableFuture<StatefulRedisConnection<K, V>>[] selectedReaderCandidates) {
        ArrayList<StatefulRedisConnection<K, V>> connections = new ArrayList<StatefulRedisConnection<K, V>>(selectedReaderCandidates.length);
        for (CompletableFuture<StatefulRedisConnection<K, V>> candidate : selectedReaderCandidates) {
            try {
                connections.add(candidate.join());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StatefulRedisConnection[] result = new StatefulRedisConnection[connections.size()];
        connections.toArray(result);
        return result;
    }

    private static <K, V> CompletableFuture<StatefulRedisConnection<K, V>> getConnection(CompletableFuture<StatefulRedisConnection<K, V>[]> root) {
        return root.thenApply(connections -> {
            for (StatefulRedisConnection connection : connections) {
                if (!connection.isOpen()) continue;
                return connection;
            }
            return connections[0];
        });
    }

    private CompletableFuture<StatefulRedisConnection<K, V>>[] getReadFromConnections(List<RedisNodeDescription> selection) {
        CompletableFuture[] readerCandidates = new CompletableFuture[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            RedisNodeDescription redisClusterNode = selection.get(i);
            RedisURI uri = redisClusterNode.getUri();
            ClusterNodeConnectionFactory.ConnectionKey key = new ClusterNodeConnectionFactory.ConnectionKey(redisClusterNode.getRole() == RedisInstance.Role.MASTER ? ClusterConnectionProvider.Intent.WRITE : ClusterConnectionProvider.Intent.READ, uri.getHost(), uri.getPort());
            readerCandidates[i] = this.getConnectionAsync(key);
        }
        return readerCandidates;
    }

    private List<RedisNodeDescription> getReadCandidates(RedisClusterNode master) {
        return this.partitions.stream().filter(partition -> this.isReadCandidate(master, (RedisClusterNode)partition)).collect(Collectors.toList());
    }

    private boolean isReadCandidate(RedisClusterNode master, RedisClusterNode partition) {
        return master.getNodeId().equals(partition.getNodeId()) || master.getNodeId().equals(partition.getSlaveOf());
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, String nodeId) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + nodeId + ")");
        }
        return this.connectionProvider.getConnection(new ClusterNodeConnectionFactory.ConnectionKey(intent, nodeId));
    }

    @Override
    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(ClusterConnectionProvider.Intent intent, String nodeId) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + nodeId + ")");
        }
        return this.getConnectionAsync(new ClusterNodeConnectionFactory.ConnectionKey(intent, nodeId));
    }

    protected CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(ClusterNodeConnectionFactory.ConnectionKey key) {
        CompletionStage future = this.connectionProvider.getConnectionAsync(key);
        CompletableFuture result = new CompletableFuture();
        future.handle((connection, throwable) -> {
            if (throwable != null) {
                if (future instanceof ConnectionFuture) {
                    ConnectionFuture connectionFuture = (ConnectionFuture)future;
                    result.completeExceptionally(RedisConnectionException.create(connectionFuture.getRemoteAddress(), throwable));
                } else {
                    result.completeExceptionally((Throwable)throwable);
                }
            } else {
                result.complete((StatefulRedisConnection)connection);
            }
            return null;
        });
        return result;
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, String host, int port) {
        try {
            this.beforeGetConnection(intent, host, port);
            ClusterNodeConnectionFactory.ConnectionKey key = new ClusterNodeConnectionFactory.ConnectionKey(intent, host, port);
            return this.connectionProvider.getConnection(key);
        }
        catch (RedisException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RedisException(e);
        }
    }

    @Override
    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(ClusterConnectionProvider.Intent intent, String host, int port) {
        try {
            this.beforeGetConnection(intent, host, port);
            return this.connectionProvider.getConnectionAsync(new ClusterNodeConnectionFactory.ConnectionKey(intent, host, port)).toCompletableFuture();
        }
        catch (RedisException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RedisException(e);
        }
    }

    private void beforeGetConnection(ClusterConnectionProvider.Intent intent, String host, int port) {
        RedisClusterNode redisClusterNode;
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + host + ", " + port + ")");
        }
        if (this.validateClusterNodeMembership() && (redisClusterNode = this.getPartition(host, port)) == null) {
            HostAndPort hostAndPort = HostAndPort.of(host, port);
            throw PooledClusterConnectionProvider.invalidConnectionPoint(hostAndPort.toString());
        }
    }

    protected RedisClusterNode getPartition(String host, int port) {
        for (RedisClusterNode partition : this.partitions) {
            RedisURI uri = partition.getUri();
            if (port != uri.getPort() || !host.equals(uri.getHost())) continue;
            return partition;
        }
        return null;
    }

    @Override
    public void close() {
        this.resetFastConnectionCache();
        this.connectionProvider.close();
    }

    @Override
    public void reset() {
        this.connectionProvider.forEach(StatefulConnection::reset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPartitions(Partitions partitions) {
        boolean reconfigurePartitions = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.partitions != null) {
                reconfigurePartitions = true;
            }
            this.partitions = partitions;
            this.connectionFactory.setPartitions(partitions);
        }
        if (reconfigurePartitions) {
            this.reconfigurePartitions();
        }
    }

    protected Partitions getPartitions() {
        return this.partitions;
    }

    private void reconfigurePartitions() {
        this.resetFastConnectionCache();
        if (this.redisClusterClient.expireStaleConnections()) {
            this.closeStaleConnections();
        }
    }

    @Override
    public void closeStaleConnections() {
        logger.debug("closeStaleConnections() count before expiring: {}", (Object)this.getConnectionCount());
        this.connectionProvider.forEach((key, connection) -> {
            if (this.isStale((ClusterNodeConnectionFactory.ConnectionKey)key)) {
                this.connectionProvider.close((ClusterNodeConnectionFactory.ConnectionKey)key);
            }
        });
        logger.debug("closeStaleConnections() count after expiring: {}", (Object)this.getConnectionCount());
    }

    private boolean isStale(ClusterNodeConnectionFactory.ConnectionKey connectionKey) {
        if (connectionKey.nodeId != null && this.partitions.getPartitionByNodeId(connectionKey.nodeId) != null) {
            return false;
        }
        return connectionKey.host == null || this.getPartition(connectionKey.host, connectionKey.port) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        Object object = this.stateLock;
        synchronized (object) {
            this.autoFlushCommands = autoFlush;
        }
        this.connectionProvider.forEach(connection -> connection.setAutoFlushCommands(autoFlush));
    }

    @Override
    public void flushCommands() {
        this.connectionProvider.forEach(StatefulConnection::flushCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadFrom(ReadFrom readFrom) {
        Object object = this.stateLock;
        synchronized (object) {
            this.readFrom = readFrom;
            Arrays.fill(this.readers, null);
        }
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    long getConnectionCount() {
        return this.connectionProvider.getConnectionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetFastConnectionCache() {
        Object object = this.stateLock;
        synchronized (object) {
            Arrays.fill(this.writers, null);
            Arrays.fill(this.readers, null);
        }
    }

    private static RuntimeException invalidConnectionPoint(String message) {
        return new IllegalArgumentException("Connection to " + message + " not allowed. This connection point is not known in the cluster view");
    }

    boolean validateClusterNodeMembership() {
        return this.redisClusterClient.getClusterClientOptions() == null || this.redisClusterClient.getClusterClientOptions().isValidateClusterNodeMembership();
    }

    protected ClusterNodeConnectionFactory<K, V> getConnectionFactory(RedisClusterClient redisClusterClient) {
        return new DefaultClusterNodeConnectionFactory<K, V>(redisClusterClient, this.redisCodec, this.clusterWriter);
    }

    static class DefaultClusterNodeConnectionFactory<K, V>
    extends AbstractClusterNodeConnectionFactory<K, V> {
        private final RedisClusterClient redisClusterClient;
        private final RedisCodec<K, V> redisCodec;
        private final RedisChannelWriter<K, V> clusterWriter;

        public DefaultClusterNodeConnectionFactory(RedisClusterClient redisClusterClient, RedisCodec<K, V> redisCodec, RedisChannelWriter<K, V> clusterWriter) {
            super(redisClusterClient.getResources());
            this.redisClusterClient = redisClusterClient;
            this.redisCodec = redisCodec;
            this.clusterWriter = clusterWriter;
        }

        @Override
        public ConnectionFuture<StatefulRedisConnection<K, V>> apply(ClusterNodeConnectionFactory.ConnectionKey key) {
            if (key.nodeId != null) {
                return this.redisClusterClient.connectToNodeAsync(this.redisCodec, key.nodeId, null, this.getSocketAddressSupplier(key));
            }
            return this.redisClusterClient.connectToNodeAsync(this.redisCodec, key.host + ":" + key.port, this.clusterWriter, this.getSocketAddressSupplier(key));
        }
    }

    private class NodeConnectionPostProcessor
    implements ClusterNodeConnectionFactory<K, V> {
        private final ClusterNodeConnectionFactory<K, V> delegate;

        public NodeConnectionPostProcessor(ClusterNodeConnectionFactory<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setPartitions(Partitions partitions) {
            this.delegate.setPartitions(partitions);
        }

        @Override
        public ConnectionFuture<StatefulRedisConnection<K, V>> apply(ClusterNodeConnectionFactory.ConnectionKey key) {
            if (key.nodeId != null && PooledClusterConnectionProvider.this.getPartitions().getPartitionByNodeId(key.nodeId) == null) {
                throw PooledClusterConnectionProvider.invalidConnectionPoint("node id " + key.nodeId);
            }
            if (key.host != null && PooledClusterConnectionProvider.this.validateClusterNodeMembership() && PooledClusterConnectionProvider.this.getPartition(key.host, key.port) == null) {
                throw PooledClusterConnectionProvider.invalidConnectionPoint(key.host + ":" + key.port);
            }
            CompletionStage connection = (ConnectionFuture)this.delegate.apply(key);
            LettuceAssert.notNull(connection, "Connection is null. Check ConnectionKey because host and nodeId are null.");
            if (key.intent == ClusterConnectionProvider.Intent.READ) {
                connection = connection.thenCompose(c -> {
                    RedisFuture<String> stringRedisFuture = c.async().readOnly();
                    return stringRedisFuture.thenApply(s -> c).whenCompleteAsync((s, throwable) -> {
                        if (throwable != null) {
                            c.close();
                        }
                    });
                });
            }
            connection = connection.thenApply(c -> {
                Object object = PooledClusterConnectionProvider.this.stateLock;
                synchronized (object) {
                    c.setAutoFlushCommands(PooledClusterConnectionProvider.this.autoFlushCommands);
                }
                return c;
            });
            return connection;
        }
    }
}

