/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.openapi.client.sdk;

import com.alibaba.fastjson.JSON;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtils {
    static Logger logger = LoggerFactory.getLogger(SignatureUtils.class);
    static final String DEFAULT_JOIN1 = "=";
    static final String DEFAULT_JOIN2 = "&";
    static final String EMPTY = "";
    static final Base64.Encoder ENCODER = Base64.getEncoder();

    public static String sign(String rawData) throws IllegalArgumentException {
        if (rawData == null || rawData.trim().length() == 0) {
            throw new IllegalArgumentException("Empty.RawData");
        }
        logger.info("Sign | RawData:{}", (Object)rawData);
        return DigestUtils.md5Hex((byte[])ENCODER.encode(rawData.getBytes()));
    }

    public static String sign(String appSecret, Map<String, Object> map) throws IllegalArgumentException {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException("Empty.Map");
        }
        if (map instanceof TreeMap) {
            return SignatureUtils.sign(appSecret, (TreeMap)map);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.putAll(map);
        return SignatureUtils.sign(appSecret, treeMap);
    }

    public static String sign(String appSecret, TreeMap<String, Object> treeMap) throws IllegalArgumentException {
        if (treeMap == null || treeMap.size() == 0) {
            throw new IllegalArgumentException("Empty.TreeMap");
        }
        if (!treeMap.containsKey("bizvane-appsecret")) {
            treeMap.put("bizvane-appsecret", appSecret);
        }
        String rawData = SignatureUtils.transform(treeMap);
        String signatrue = SignatureUtils.sign(rawData);
        treeMap.remove("bizvane-appsecret");
        return signatrue;
    }

    public static boolean verifySign(String rawData, String sign) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("RawData:{}", (Object)rawData);
            logger.debug("Sign:{}", (Object)sign);
        }
        if (rawData == null || rawData.trim().length() == 0) {
            throw new IllegalArgumentException("Empty.RawData");
        }
        if (sign == null || sign.trim().length() == 0) {
            throw new IllegalArgumentException("Empty.Signature");
        }
        return sign.equals(DigestUtils.md5Hex((byte[])ENCODER.encode(rawData.getBytes())));
    }

    public static boolean verifySign(String appSecret, Map<String, Object> map, String sign) throws IllegalArgumentException {
        if (map == null || map.size() == 0) {
            throw new IllegalArgumentException("Empty.Map");
        }
        if (map instanceof TreeMap) {
            return SignatureUtils.verifySign(appSecret, (TreeMap)map, sign);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.putAll(map);
        return SignatureUtils.verifySign(appSecret, treeMap, sign);
    }

    public static boolean verifySign(String appSecret, TreeMap<String, Object> treeMap, String sign) throws IllegalArgumentException {
        if (treeMap == null || treeMap.size() == 0) {
            throw new IllegalArgumentException("Empty.TreeMap");
        }
        if (!treeMap.containsKey("bizvane-appsecret")) {
            treeMap.put("bizvane-appsecret", appSecret);
        }
        String rawData = SignatureUtils.transform(treeMap);
        boolean verify = SignatureUtils.verifySign(rawData, sign);
        treeMap.remove("bizvane-appsecret");
        return verify;
    }

    public static String transform(TreeMap<String, Object> treeMap) {
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        for (Map.Entry<String, Object> entry : treeMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().equals(EMPTY)) continue;
            if (index++ > 0) {
                stringBuilder.append(DEFAULT_JOIN2);
            }
            stringBuilder.append(entry.getKey()).append(DEFAULT_JOIN1);
            if (entry.getValue() instanceof String) {
                stringBuilder.append(String.valueOf(entry.getValue()));
                continue;
            }
            stringBuilder.append(JSON.toJSONString((Object)entry.getValue()));
        }
        return stringBuilder.toString();
    }

    public static boolean verySignature(Map<String, Object> headers, Map<String, Object> body, String appSecret) {
        Object object = headers.get("bizvane-signature-headers");
        if (object == null || EMPTY.equals(object.toString().trim())) {
            return false;
        }
        Object signature = headers.get("bizvane-signature");
        if (signature == null || EMPTY.equals(signature.toString().trim())) {
            return false;
        }
        String signatureHeaders = object.toString();
        String[] signatureHeaderArray = signatureHeaders.split(",");
        HashMap<String, Object> params = new HashMap<String, Object>(signatureHeaderArray.length + 5);
        for (String key : signatureHeaderArray) {
            params.put(key, headers.get(key));
        }
        params.putAll(body);
        return SignatureUtils.verifySign(appSecret, params, signature.toString());
    }
}

