/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.admin.promotion.controller;

import com.alibaba.fastjson.JSONArray;
import com.ztesoft.zsmart.nros.base.annotation.SessionController;
import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.base.util.CommonFunctions;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.PromotionConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.SingleGoodsConvert;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.GoodsRangeDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.PromotionDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.SingleGoodsDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.SingleGoodsDetailDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.StoreDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.AssociationRuleSaveParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.GoodsRangeDeleteParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.GoodsRangeParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.PromotionDeleteParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.PromotionParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.SingleGoodsDeleteParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.param.SingleGoodsParam;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.GoodsRangeQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.PromotionQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.SingleGoodsQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.query.StoreQuery;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.PromotionVO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.SingleGoodsVO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.service.BasedataToPromotionService;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.service.PromotionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@SessionController
@RequestMapping(value={"/promotion"})
@Api(value="\u4fc3\u9500\u6d3b\u52a8\u7ba1\u7406", tags={"\u4fc3\u9500\u6d3b\u52a8\u7ba1\u7406"})
public class PromotionController {
    @Autowired
    private PromotionService promotionService;
    @Autowired
    private PromotionConvertor promotionConvertor;
    @Autowired
    private SingleGoodsConvert singleGoodsConvert;
    @Autowired
    private BasedataToPromotionService basedataService;

    @PostMapping(value={"/save-promotion-info"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u65b0\u589e\u4fc3\u9500\u6d3b\u52a8\u57fa\u672c\u4fe1\u606f")
    public ResponseMsg savePromotionInfo(@RequestBody PromotionParam promotionParam) {
        return this.promotionService.savePromotionInfo(promotionParam);
    }

    @PutMapping(value={"/update-promotion-with-rule"})
    @ApiOperation(value="/\u6d3b\u52a8\u6dfb\u52a0\u89c4\u5219\u4fe1\u606f")
    public ResponseMsg<Integer> updatePromotionWithRule(@RequestBody AssociationRuleSaveParam associationRuleSaveParam) {
        return this.promotionService.updatePromotionWithRule(associationRuleSaveParam);
    }

    @DeleteMapping(value={"/delete-promotion"})
    @ApiOperation(value="\u5220\u9664\u4fc3\u9500\u6d3b\u52a8")
    public ResponseMsg deletePromotion(@RequestBody PromotionDeleteParam promotionDeleteParam) {
        this.promotionService.deletePromotion(promotionDeleteParam);
        return new ResponseMsg().success();
    }

    @PostMapping(value={"/page-promotion"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u5217\u8868")
    public ResponseMsg<List<PromotionVO>> pagePromotion(@RequestBody PromotionQuery promotionQuery) {
        ResponseMsg<List<PromotionDTO>> listResponseMsg = this.promotionService.pagePromotion(promotionQuery);
        return CommonFunctions.runTranslateByList(listResponseMsg, () -> {
            List<PromotionVO> promotionVOS = this.promotionConvertor.dtosToVOS((List)listResponseMsg.getData());
            return promotionVOS;
        });
    }

    @PostMapping(value={"/detail-promotion"})
    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u8be6\u60c5")
    public ResponseMsg<PromotionVO> detailPromotion(@RequestBody PromotionQuery promotionQuery) {
        ResponseMsg<PromotionDTO> promotionDTOResponseMsg = this.promotionService.detailPromotion(promotionQuery);
        PromotionVO promotionVO = this.promotionConvertor.dtoToVO((PromotionDTO)promotionDTOResponseMsg.getData());
        if (promotionVO != null) {
            if (CollectionUtils.isNotEmpty((Collection)promotionVO.getChannel())) {
                List<String> channelNames = this.basedataService.getChannelNameByFieldCodes(JSONArray.parseArray((String)promotionVO.getChannel().toJSONString(), String.class));
                promotionVO.setChannelNames(channelNames);
            }
            if (CollectionUtils.isNotEmpty((Collection)promotionVO.getStoreCode())) {
                StoreQuery storeQuery = new StoreQuery();
                storeQuery.setOrgCodes(JSONArray.parseArray((String)promotionVO.getStoreCode().toJSONString(), String.class));
                List<StoreDTO> storeDTOS = this.basedataService.queryStoreList(storeQuery);
                if (CollectionUtils.isNotEmpty(storeDTOS)) {
                    promotionVO.setStoreNames(storeDTOS.stream().map(StoreDTO::getName).collect(Collectors.toList()));
                }
            }
        }
        return CommonFunctions.runSupplier(() -> promotionVO, (String)"\u67e5\u8be2\u6d3b\u52a8\u8be6\u60c5\u5f02\u5e38");
    }

    @PostMapping(value={"/save-goods-range-type"})
    @ApiOperation(value="\u6d3b\u52a8\u6dfb\u52a0\u5546\u54c1\u8303\u56f4\u7c7b\u578b")
    public ResponseMsg<Integer> saveGoodsRangeType(@RequestBody PromotionParam promotionParam) {
        return this.promotionService.saveGoodsRangeType(promotionParam);
    }

    @PostMapping(value={"/save-goods-range"})
    @ApiOperation(value="\u6d3b\u52a8\u6dfb\u52a0\u5546\u54c1\u8303\u56f4\u4fe1\u606f")
    public ResponseMsg<Long> saveGoodsRange(@RequestBody GoodsRangeParam goodsRangeParam) {
        return this.promotionService.saveGoodsRange(goodsRangeParam);
    }

    @PostMapping(value={"goods-ranges/batch-save"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6d3b\u52a8\u5546\u54c1\u8303\u56f4")
    public ResponseMsg batchSaveGoodsRanges(@RequestBody List<GoodsRangeParam> goodsRangeParams) {
        return this.promotionService.batchSaveGoodsRanges(goodsRangeParams);
    }

    @PostMapping(value={"/save-single-goods"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u54c1")
    public ResponseMsg<Long> saveSingleGoods(@RequestBody SingleGoodsParam singleGoodsParam) {
        return this.promotionService.saveSingleGoods(singleGoodsParam);
    }

    @PostMapping(value={"/detail-single-goods"})
    @ApiOperation(value="\u67e5\u8be2\u5355\u54c1\u8be6\u60c5")
    public ResponseMsg<SingleGoodsVO> detailSingleGoods(@RequestBody SingleGoodsQuery singleGoodsQuery) {
        ResponseMsg<SingleGoodsDetailDTO> singleGoodsDetailDTOResponseMsg = this.promotionService.detailSingleGoods(singleGoodsQuery);
        return CommonFunctions.runSupplier(() -> this.singleGoodsConvert.dtoToVO((SingleGoodsDetailDTO)singleGoodsDetailDTOResponseMsg.getData()), (String)"\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5f02\u5e38");
    }

    @PostMapping(value={"/page-single-goods"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868")
    public ResponseMsg<List<SingleGoodsVO>> pageSingleGoods(@RequestBody SingleGoodsQuery singleGoodsQuery) {
        ResponseMsg<List<SingleGoodsDTO>> listResponseMsg = this.promotionService.pageSingleGoods(singleGoodsQuery);
        return CommonFunctions.runSupplierByList(() -> this.singleGoodsConvert.dtosToVOS((List)listResponseMsg.getData()), (String)"\u5206\u9875\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u5217\u8868\u5f02\u5e38");
    }

    @DeleteMapping(value={"/delete-single-goods"})
    @ApiOperation(value="\u5220\u9664\u5355\u54c1")
    public ResponseMsg<Integer> deleteSingleGoods(@RequestBody SingleGoodsDeleteParam singleGoodsDeleteParam) {
        return this.promotionService.deleteSingleGoods(singleGoodsDeleteParam);
    }

    @DeleteMapping(value={"/delete-goods-range"})
    @ApiOperation(value="\u5220\u9664\u5546\u54c1\u8303\u56f4")
    public ResponseMsg<Integer> deleteGoodsRange(@RequestBody GoodsRangeDeleteParam goodsRangeDeleteParam) {
        return this.promotionService.deleteGoodsRange(goodsRangeDeleteParam);
    }

    @PostMapping(value={"/page-goods-range"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5546\u54c1\u8303\u56f4\u4fe1\u606f\u5217\u8868")
    public ResponseMsg<List<GoodsRangeDTO>> pageGoodsRange(@RequestBody GoodsRangeQuery goodsRangeQuery) {
        return this.promotionService.pageGoodsRange(goodsRangeQuery);
    }

    @PutMapping(value={"/enable-promotion"})
    @ApiOperation(value="\u542f\u7528\u6d3b\u52a8")
    public ResponseMsg<Integer> enablePromotion(@RequestBody PromotionParam promotionParam) {
        return this.promotionService.enablePromotion(promotionParam);
    }

    @PutMapping(value={"/disable-promotion"})
    @ApiOperation(value="\u505c\u7528\u6d3b\u52a8")
    public ResponseMsg<Integer> disablePromotion(@RequestBody PromotionParam promotionParam) {
        return this.promotionService.disablePromotion(promotionParam);
    }
}

