/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor;

import com.alibaba.fastjson.JSONObject;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.ConditionConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.DiscountConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.GiftConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.GiftCouponConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.common.convertor.PurchaseConvertor;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.dto.ConditionDTO;
import com.ztesoft.zsmart.nros.sbc.admin.promotion.model.vo.ConditionVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConditionConvertorImpl
extends ConditionConvertor {
    @Autowired
    private DiscountConvertor discountConvertor;
    @Autowired
    private GiftConvertor giftConvertor;
    @Autowired
    private GiftCouponConvertor giftCouponConvertor;
    @Autowired
    private PurchaseConvertor purchaseConvertor;

    @Override
    public List<ConditionVO> dtosToConditionVOS(List<ConditionDTO> conditionDTOS) {
        if (conditionDTOS == null) {
            return null;
        }
        ArrayList<ConditionVO> list = new ArrayList<ConditionVO>(conditionDTOS.size());
        for (ConditionDTO conditionDTO : conditionDTOS) {
            list.add(this.conditionDTOToConditionVO(conditionDTO));
        }
        return list;
    }

    protected ConditionVO conditionDTOToConditionVO(ConditionDTO conditionDTO) {
        if (conditionDTO == null) {
            return null;
        }
        ConditionVO conditionVO = new ConditionVO();
        conditionVO.setCreatorUserId(conditionDTO.getCreatorUserId());
        conditionVO.setCreatorUserName(conditionDTO.getCreatorUserName());
        conditionVO.setModifyUserId(conditionDTO.getModifyUserId());
        conditionVO.setModifyUserName(conditionDTO.getModifyUserName());
        conditionVO.setId(conditionDTO.getId());
        conditionVO.setStatus(conditionDTO.getStatus());
        conditionVO.setMerchantCode(conditionDTO.getMerchantCode());
        JSONObject jSONObject = conditionDTO.getCreator();
        if (jSONObject != null) {
            conditionVO.setCreator(new JSONObject((Map)jSONObject));
        } else {
            conditionVO.setCreator(null);
        }
        conditionVO.setGmtCreate(conditionDTO.getGmtCreate());
        JSONObject jSONObject1 = conditionDTO.getModifier();
        if (jSONObject1 != null) {
            conditionVO.setModifier(new JSONObject((Map)jSONObject1));
        } else {
            conditionVO.setModifier(null);
        }
        conditionVO.setGmtModified(conditionDTO.getGmtModified());
        conditionVO.setAppId(conditionDTO.getAppId());
        JSONObject jSONObject2 = conditionDTO.getExtInfo();
        if (jSONObject2 != null) {
            conditionVO.setExtInfo(new JSONObject((Map)jSONObject2));
        } else {
            conditionVO.setExtInfo(null);
        }
        conditionVO.setConditionType(conditionDTO.getConditionType());
        conditionVO.setAction(conditionDTO.getAction());
        conditionVO.setAmountOfMoney(conditionDTO.getAmountOfMoney());
        conditionVO.setQuantity(conditionDTO.getQuantity());
        conditionVO.setDiscountName(conditionDTO.getDiscountName());
        conditionVO.setRuleId(conditionDTO.getRuleId());
        conditionVO.setDiscount(this.discountConvertor.dtoToVO(conditionDTO.getDiscount()));
        conditionVO.setGiftList(this.giftConvertor.dtosToGiftVOS(conditionDTO.getGiftList()));
        conditionVO.setGiftCouponList(this.giftCouponConvertor.dtosToGiftCouponVOS(conditionDTO.getGiftCouponList()));
        conditionVO.setPurchaseList(this.purchaseConvertor.dtosToPurchaseVOS(conditionDTO.getPurchaseList()));
        return conditionVO;
    }
}

