/*
 * Decompiled with CFR 0.152.
 */
package com.chinapay.secss.util;

import com.chinapay.secss.util.HexUtils;
import com.chinapay.secss.util.JiaMiUtil;
import com.enation.app.javashop.framework.util.DateUtil;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayUtil {
    private static int isload = 0;
    private static String[] licenses = null;
    private static String newPublicKey = "30819f300d06092a864886f70d010101050003818d0030818902818100996b56ccc3703e6fa979ee474ab95c91c25a8c8e7454d2fd95207a57b92a1fe02a71d3aff40b3d56f6f5715245e4629767898ea8023553f18e442e10f23ded13a77ca33056a4bb072664e6dc5757d304f9c6ac8f204ed65c727c2a71c49b4978da9dab9224bf7e30e33e3a6b4c8f4315a523e468de4c8eab1e1dfe785d4f39190203010001";

    private static boolean verifySign(String hexPublicKey, String signedStr, String str) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(HexUtils.hexStrToBytes(hexPublicKey));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            byte[] signed = HexUtils.hexStrToBytes(signedStr);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(publicKey);
            signature.update(str.getBytes());
            return signature.verify(signed);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void load(List<String> list) {
        licenses = list.toArray(new String[list.size()]);
    }

    public static boolean verify(String domain) {
        try {
            if (licenses == null || licenses.length == 0) {
                return false;
            }
            for (String license : licenses) {
                try {
                    if (!PayUtil.verifyLicense(license, domain)) continue;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean verifyLicense(String license, String domain) {
        String[] ar = license.split(",");
        int size = ar.length;
        if (size != 2) {
            return false;
        }
        String sign = ar[0];
        String text = ar[1];
        boolean signResult = PayUtil.verifySign(newPublicKey, sign, text);
        if (signResult) {
            text = JiaMiUtil.decryptCode(text);
            return PayUtil.fenxi(text, domain);
        }
        return false;
    }

    private static boolean fenxi(String str, String checkDomian) {
        String version = null;
        String type = null;
        String domain = null;
        String timeout = null;
        String ipstart = null;
        String ipend = null;
        String[] arr = str.split(",");
        if (arr.length > 1) {
            version = PayUtil.getValue(arr[0], "version");
        }
        if (arr.length > 2) {
            type = PayUtil.getValue(arr[1], "type");
        }
        if (arr.length > 3) {
            domain = PayUtil.getValue(arr[2], "domain");
        }
        if (arr.length >= 4) {
            timeout = PayUtil.getValue(arr[3], "timeout");
        }
        if (arr.length >= 5) {
            ipstart = PayUtil.getValue(arr[4], "ipstart");
        }
        if (arr.length >= 6) {
            ipend = PayUtil.getValue(arr[5], "ipend");
        }
        if ("6.5".equals(version)) {
            long timeoutL;
            long now;
            boolean domainResult = false;
            boolean timeResult = false;
            domainResult = PayUtil.checkDomain(type, checkDomian, domain, ipstart, ipend);
            timeResult = !"nolimit".equals(timeout) ? (now = DateUtil.getDateline()) < (timeoutL = Long.valueOf(timeout).longValue()) : true;
            return domainResult && timeResult;
        }
        return false;
    }

    private static boolean checkDomain(String type, String currentDomain, String enableDomain, String ipstart, String ipend) {
        boolean domainResult = false;
        if ("1".equals(type) && currentDomain.contains(enableDomain)) {
            domainResult = true;
        }
        if ("0".equals(type) && currentDomain.equals(enableDomain)) {
            domainResult = true;
        }
        if ("2".equals(type)) {
            long checkip = PayUtil.ipToLong(currentDomain);
            long startip = PayUtil.ipToLong(ipstart);
            long endip = PayUtil.ipToLong(ipend);
            if (startip <= checkip && checkip <= endip) {
                domainResult = true;
            }
        }
        return domainResult;
    }

    private static String getValue(String str, String pre) {
        if (str.startsWith(pre)) {
            String[] arr = str.split(":");
            if (arr.length <= 1) {
                return null;
            }
            return arr[1];
        }
        return null;
    }

    private static long ipToLong(String strIp) {
        long[] ip = new long[4];
        int position1 = strIp.indexOf(".");
        int position2 = strIp.indexOf(".", position1 + 1);
        int position3 = strIp.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIp.substring(0, position1));
        ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIp.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    private static String longToIP(long longIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIp & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIp & 0xFFL));
        return sb.toString();
    }
}

