/*
 * Decompiled with CFR 0.152.
 */
package com.chinapay.secss;

import com.chinapay.secss.CPEncryptAndDecrypt;
import com.chinapay.secss.CertUtil;
import com.chinapay.secss.LogUtil;
import com.chinapay.secss.SecssConstants;
import com.chinapay.secss.SecureUtil;
import com.chinapay.secss.SecurityException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;

public class SecssUtil {
    private static final char CHAR_RTN_N = '\n';
    private static final char CHAR_RTN_R = '\r';
    private static final int BUFFER_SIZE = 4096;
    private String sign;
    private String encPin;
    private String encValue;
    private String decValue;
    private String certId;
    private String errCode;
    private String errMsg;
    private boolean initFlag1 = false;
    private boolean initFlag2 = false;
    private long hashLength = 40960L;
    private CertUtil certUtil;
    private static Map<String, CertUtil> certUtilMap = new HashMap<String, CertUtil>();
    private static String CERTUTILMAP_DEFAULT_KEY = "DEFAULT";
    private boolean ignoreCache = false;

    public SecssUtil() {
        this(false);
    }

    public SecssUtil(boolean ignoreCertCache) {
        this.ignoreCache = ignoreCertCache;
    }

    public synchronized boolean init() {
        if (this.initFlag1) {
            LogUtil.writeLog("\u5df2\u7ecf\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u8fc7\u5b89\u5168\u63a7\u4ef6\uff0c\u4e0d\u518d\u4f5c\u91cd\u590d\u521d\u59cb\u5316\u5de5\u4f5c.");
            return true;
        }
        LogUtil.writeLog("\u5f00\u59cb\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6.");
        try {
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            this.loadCertUtil(null);
            this.initFlag1 = true;
            this.initFlag2 = false;
            this.errCode = SecssConstants.SUCCESS;
            return true;
        }
        catch (SecurityException e) {
            LogUtil.writeErrorLog("\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", e);
            this.errCode = e.getErrCode();
            this.initFlag1 = false;
            return false;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", e);
            this.errCode = SecssConstants.DEFAULTINIT_GOES_WRONG;
            this.initFlag1 = false;
            return false;
        }
        finally {
            LogUtil.writeLog("\u4ece\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u7ed3\u675f.");
        }
    }

    public synchronized boolean init(String propPath) {
        LogUtil.writeLog("\u5f00\u59cb\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6.");
        try {
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            this.loadCertUtil(propPath);
            this.initFlag2 = true;
            this.initFlag1 = false;
            this.errCode = SecssConstants.SUCCESS;
            return true;
        }
        catch (SecurityException e) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", e);
            this.errCode = e.getErrCode();
            this.initFlag2 = false;
            return false;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", e);
            this.errCode = SecssConstants.SPECIFYINIT_GOES_WRONG;
            this.initFlag2 = false;
            return false;
        }
        finally {
            LogUtil.writeLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u7ed3\u675f.");
        }
    }

    public synchronized boolean init(Properties props) {
        LogUtil.writeLog("\u5f00\u59cb\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6.");
        try {
            this.errCode = SecssConstants.UNKNOWN_WRONG;
            this.certUtil = CertUtil.init(props);
            this.initFlag2 = true;
            this.initFlag1 = false;
            this.errCode = SecssConstants.SUCCESS;
            return true;
        }
        catch (SecurityException e) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", e);
            this.errCode = e.getErrCode();
            this.initFlag2 = false;
            return false;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u5f02\u5e38", e);
            this.errCode = SecssConstants.SPECIFYINIT_GOES_WRONG;
            this.initFlag2 = false;
            return false;
        }
        finally {
            LogUtil.writeLog("\u4ece\u6307\u5b9a\u5c5e\u6027\u96c6\u521d\u59cb\u5316\u5b89\u5168\u63a7\u4ef6\u7ed3\u675f.");
        }
    }

    public void clearCert() {
        certUtilMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCertUtil(String path) throws SecurityException {
        boolean isPathEmpty;
        String key = null;
        boolean bl = isPathEmpty = path == null || path.trim().length() == 0;
        if (this.ignoreCache) {
            if (isPathEmpty) {
                this.certUtil = CertUtil.init();
            } else {
                Properties pros = this.loadProp(path);
                this.certUtil = CertUtil.init(pros);
            }
        } else {
            key = isPathEmpty ? CERTUTILMAP_DEFAULT_KEY : path;
            this.certUtil = certUtilMap.get(key);
            if (this.certUtil == null) {
                Map<String, CertUtil> map = certUtilMap;
                synchronized (map) {
                    this.certUtil = certUtilMap.get(key);
                    if (this.certUtil == null) {
                        if (isPathEmpty) {
                            this.certUtil = CertUtil.init();
                        } else {
                            Properties pros = this.loadProp(path);
                            this.certUtil = CertUtil.init(pros);
                        }
                        certUtilMap.put(key, this.certUtil);
                    }
                }
            }
        }
    }

    private Properties loadProp(String propPath) {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(propPath);
                props.load(is);
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
                this.errCode = SecssConstants.SPECIFYINIT_GOES_WRONG;
                this.initFlag2 = false;
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    public boolean reloadSignCert(String certPath, String pass) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u4e4b\u524d\uff0c\u8bf7\u5148\u786e\u4fdd\u5df2\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u8fc7\u63a7\u4ef6");
            return false;
        }
        LogUtil.writeLog("\u5f00\u59cb\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66.");
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            this.certUtil.reloadSignCert(certPath, pass);
            return true;
        }
        catch (SecurityException e) {
            LogUtil.writeErrorLog("\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5f02\u5e38", e);
            this.errCode = e.getErrCode();
            return false;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5f02\u5e38", e);
            this.errCode = SecssConstants.RELOADSC_GOES_WRONG;
            return false;
        }
        finally {
            LogUtil.writeLog("\u91cd\u65b0\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
        }
    }

    public void sign(Map map) {
        this.sign(map, SecssConstants.SIGN512_ALGNAME);
    }

    public void sign(Map map, String signAlg) {
        this.sign(map, signAlg, SecssConstants.SIGN512, this.hashLength);
    }

    protected void sign(Map map, String signAlg, String hashAlg, long hashLength) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
            return;
        }
        LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u5f00\u59cb.");
        this.sign = null;
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            try {
                PrivateKey priKey;
                String dataStr = this.getSignStr(map, this.certUtil.getSecssConfig().getInvalidFileds(), true);
                LogUtil.writeLog(new StringBuffer().append("\u62a5\u6587\u7b7e\u540d\u4e4b\u524d\u7684\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[").append(dataStr).append("]").toString());
                byte[] dataBytes = dataStr.getBytes(SecssConstants.CHARSET_COMM);
                if (hashAlg != null && hashAlg.trim().length() > 0 && (long)dataBytes.length > hashLength) {
                    dataBytes = this.hashBytes(hashAlg, dataBytes);
                }
                if ((priKey = this.certUtil.getPriKey()) == null) {
                    throw new Exception("\u83b7\u53d6\u5230\u7684\u79c1\u94a5\u4e3a\u7a7a");
                }
                byte[] signBytes = null;
                signBytes = SecureUtil.sign(dataBytes, priKey, signAlg);
                this.sign = new String(Base64.encodeBase64((byte[])signBytes), SecssConstants.CHARSET_COMM);
                LogUtil.writeLog(new StringBuffer().append("\u62a5\u6587\u7b7e\u540d\u4e4b\u540e\u7684\u5b57\u7b26\u4e32=[").append(this.sign).append("]").toString());
                this.certId = this.certUtil.getSignCertId();
                LogUtil.writeLog(new StringBuffer().append("\u7b7e\u540d\u8bc1\u4e66ID=[").append(this.certId).append("]").toString());
                this.errCode = SecssConstants.SUCCESS;
            }
            catch (SecurityException e) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", e);
                this.errCode = e.getErrCode();
                LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
                return;
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", e);
                this.errCode = SecssConstants.SIGN_GOES_WRONG;
                LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
                return;
            }
        }
        finally {
            LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
        }
    }

    public void signBatch(Map map) {
        this.signBatch(map, SecssConstants.SIGN512_ALGNAME);
    }

    public void signBatch(Map map, String signAlg) {
        this.signBatch(map, signAlg, SecssConstants.SIGN512);
    }

    protected void signBatch(Map map, String signAlg, String hashAlg) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
            return;
        }
        LogUtil.writeLog("\u6279\u91cf\u7b7e\u540d\u5904\u7406\u5f00\u59cb.");
        this.sign = null;
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            try {
                PrivateKey priKey;
                String dataStr = this.getSignStr(map, this.certUtil.getSecssConfig().getInvalidFileds(), true);
                LogUtil.writeLog(new StringBuffer().append("\u62a5\u6587\u7b7e\u540d\u4e4b\u524d\u7684\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[").append(dataStr).append("]").toString());
                byte[] dataBytes = dataStr.getBytes(SecssConstants.CHARSET_COMM);
                if (hashAlg != null && hashAlg.trim().length() > 0) {
                    dataBytes = this.hashBytes(hashAlg, dataBytes);
                }
                if ((priKey = this.certUtil.getPriKey()) == null) {
                    throw new Exception("\u83b7\u53d6\u5230\u7684\u79c1\u94a5\u4e3a\u7a7a");
                }
                byte[] signBytes = null;
                signBytes = SecureUtil.sign(dataBytes, priKey, signAlg);
                this.sign = new String(Base64.encodeBase64((byte[])signBytes), SecssConstants.CHARSET_COMM);
                LogUtil.writeLog(new StringBuffer().append("\u62a5\u6587\u7b7e\u540d\u4e4b\u540e\u7684\u5b57\u7b26\u4e32=[").append(this.sign).append("]").toString());
                this.certId = this.certUtil.getSignCertId();
                LogUtil.writeLog(new StringBuffer().append("\u7b7e\u540d\u8bc1\u4e66ID=[").append(this.certId).append("]").toString());
                this.errCode = SecssConstants.SUCCESS;
            }
            catch (SecurityException e) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", e);
                this.errCode = e.getErrCode();
                LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
                return;
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u5f02\u5e38", e);
                this.errCode = SecssConstants.SIGN_GOES_WRONG;
                LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
                return;
            }
        }
        finally {
            LogUtil.writeLog("\u7b7e\u540d\u5904\u7406\u7ed3\u675f.");
        }
    }

    public void verify(Map map) {
        this.verify(map, SecssConstants.SIGN512_ALGNAME);
    }

    public void verify(Map map, String verifyAlg) {
        this.verify(map, verifyAlg, SecssConstants.SIGN512, this.hashLength);
    }

    protected void verify(Map map, String verifyAlg, String hashAlg, long hashLength) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u9a8c\u7b7e\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
            return;
        }
        LogUtil.writeLog("\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb.");
        boolean result = false;
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            String signFieldName = this.certUtil.getSecssConfig().getSignFieldName();
            if (SecssUtil.isEmpty(signFieldName)) {
                this.errCode = SecssConstants.SIGN_FIELD_NULL;
                return;
            }
            String signStr = (String)map.get(signFieldName);
            LogUtil.writeLog(new StringBuffer().append("\u7b7e\u540d\u4e32=[").append(signStr).append("]").toString());
            if (SecssUtil.isEmpty(signStr)) {
                this.errCode = SecssConstants.SIGN_VALUE_NULL;
                return;
            }
            try {
                PublicKey pubKey;
                List invalidFields = this.certUtil.getSecssConfig().getInvalidFileds();
                String dataStr = this.getSignStr(map, invalidFields, true);
                LogUtil.writeLog(new StringBuffer().append("\u539f\u62a5\u6587\u5b57\u7b26\u4e32(\u4e0d\u542bsignature\u57df)=[").append(dataStr).append("]").toString());
                byte[] dataBytes = dataStr.getBytes(SecssConstants.CHARSET_COMM);
                if (hashAlg != null && hashAlg.trim().length() > 0 && (long)dataBytes.length > hashLength) {
                    dataBytes = this.hashBytes(hashAlg, dataBytes);
                }
                if ((pubKey = this.certUtil.getPubKey()) == null) {
                    throw new Exception("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
                }
                byte[] signBytes = Base64.decodeBase64((byte[])signStr.getBytes(SecssConstants.CHARSET_COMM));
                result = SecureUtil.verify(dataBytes, signBytes, pubKey, verifyAlg);
                this.errCode = result ? SecssConstants.SUCCESS : SecssConstants.VERIFY_FAILED;
                LogUtil.writeLog(new StringBuffer().append("\u9a8c\u7b7e\u7ed3\u679c=[").append(SecssConstants.SUCCESS.equals(this.errCode)).append("]").toString());
            }
            catch (SecurityException e) {
                LogUtil.writeErrorLog("\u9a8c\u7b7e\u5f02\u5e38", e);
                this.errCode = e.getErrCode();
                return;
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("\u9a8c\u7b7e\u5f02\u5e38", e);
                this.errCode = SecssConstants.VERIFY_GOES_WRONG;
                return;
            }
        }
        finally {
            LogUtil.writeLog("\u9a8c\u7b7e\u5904\u7406\u7ed3\u675f.");
        }
    }

    public void encryptPin(String pin, String card) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884cPin\u52a0\u5bc6\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
            return;
        }
        LogUtil.writeLog("Pin\u52a0\u5bc6\u5904\u7406\u5f00\u59cb.");
        this.encPin = null;
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            try {
                byte[] pinBlock = SecureUtil.pin2PinBlockWithCardNO(pin, card);
                if (SecssUtil.isEmpty(pinBlock)) {
                    throw new Exception("\u8ba1\u7b97\u5f97\u5230\u7684PinBlock\u4e3a\u7a7a");
                }
                this.encPin = this.encryptDataLocal(pinBlock);
                this.errCode = SecssConstants.SUCCESS;
                LogUtil.writeLog(new StringBuffer().append("Pin\u52a0\u5bc6\u7ed3\u679c=[").append(this.encPin).append("]").toString());
            }
            catch (SecurityException e) {
                LogUtil.writeErrorLog("Pin\u52a0\u5bc6\u5f02\u5e38", e);
                this.errCode = e.getErrCode();
                LogUtil.writeLog("Pin\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
                return;
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("Pin\u52a0\u5bc6\u5f02\u5e38", e);
                this.errCode = SecssConstants.ENCPIN_GOES_WRONG;
                LogUtil.writeLog("Pin\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
                return;
            }
        }
        finally {
            LogUtil.writeLog("Pin\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
        }
    }

    public void encryptData(String data) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u52a0\u5bc6\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
            return;
        }
        LogUtil.writeLog("\u6570\u636e\u52a0\u5bc6\u5904\u7406\u5f00\u59cb.");
        this.encValue = null;
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            try {
                this.encValue = this.encryptDataLocal(data.getBytes(SecssConstants.CHARSET_COMM));
                this.errCode = SecssConstants.SUCCESS;
                LogUtil.writeLog(new StringBuffer().append("\u6570\u636e\u52a0\u5bc6\u7ed3\u679c=[").append(this.encValue).append("]").toString());
            }
            catch (SecurityException e) {
                LogUtil.writeErrorLog("\u6570\u636e\u52a0\u5bc6\u5f02\u5e38", e);
                this.errCode = e.getErrCode();
                LogUtil.writeLog("\u6570\u636e\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
                return;
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("\u6570\u636e\u52a0\u5bc6\u5f02\u5e38", e);
                this.errCode = SecssConstants.ENCDATA_GOES_WRONG;
                LogUtil.writeLog("\u6570\u636e\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
                return;
            }
        }
        finally {
            LogUtil.writeLog("\u6570\u636e\u52a0\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
        }
    }

    public void decryptData(String data) {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u89e3\u5bc6\u64cd\u4f5c\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
            return;
        }
        LogUtil.writeLog("\u6570\u636e\u89e3\u5bc6\u5904\u7406\u5f00\u59cb.");
        this.decValue = null;
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            try {
                LogUtil.writeLog(new StringBuffer().append("\u89e3\u5bc6\u524d\u6570\u636e=[").append(data).append("]").toString());
                this.decValue = this.decryptDataLocal(Base64.decodeBase64((String)data));
                this.errCode = SecssConstants.SUCCESS;
                LogUtil.writeLog(new StringBuffer().append("\u6570\u636e\u89e3\u5bc6\u7ed3\u679c=[").append(this.decValue).append("]").toString());
            }
            catch (SecurityException e) {
                LogUtil.writeErrorLog("\u6570\u636e\u89e3\u5bc6\u5f02\u5e38", e);
                this.errCode = e.getErrCode();
                LogUtil.writeLog("\u6570\u636e\u89e3\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
                return;
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("\u6570\u636e\u89e3\u5bc6\u5f02\u5e38", e);
                this.errCode = SecssConstants.DECDATA_GOES_WRONG;
                LogUtil.writeLog("\u6570\u636e\u89e3\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
                return;
            }
        }
        finally {
            LogUtil.writeLog("\u6570\u636e\u89e3\u5bc6\u5904\u7406\u5904\u7406\u7ed3\u675f.");
        }
    }

    public void getSignCertId() {
        if (!this.initFlag1 && !this.initFlag2) {
            LogUtil.writeErrorLog("\u8fdb\u884c\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u4e4b\u524d\uff0c\u8bf7\u5148\u901a\u8fc7\u9ed8\u8ba4\u6216\u6307\u5b9a\u5c5e\u6027\u96c6\u65b9\u5f0f\u521d\u59cb\u5316\u63a7\u4ef6");
            this.errCode = SecssConstants.NO_INIT;
            return;
        }
        LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u5f00\u59cb.");
        this.certId = null;
        this.errCode = SecssConstants.UNKNOWN_WRONG;
        try {
            try {
                this.certId = this.certUtil.getSignCertId();
                LogUtil.writeLog(new StringBuffer().append("\u7b7e\u540d\u8bc1\u4e66ID=[").append(this.certId).append("]").toString());
                this.errCode = SecssConstants.SUCCESS;
            }
            catch (SecurityException e) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u5f02\u5e38", e);
                this.errCode = e.getErrCode();
                LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u7ed3\u675f.");
                return;
            }
            catch (Exception e) {
                LogUtil.writeErrorLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u5f02\u5e38", e);
                this.errCode = SecssConstants.GET_CERT_ID_ERROR;
                LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u7ed3\u675f.");
                return;
            }
        }
        finally {
            LogUtil.writeLog("\u7b7e\u540d\u8bc1\u4e66ID\u83b7\u53d6\u7ed3\u675f.");
        }
    }

    private String encryptDataLocal(byte[] dataBytes) throws SecurityException, Exception {
        PublicKey pubKey = this.certUtil.getPubKey();
        if (pubKey == null) {
            throw new Exception("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
        }
        byte[] encBytes = SecureUtil.encryptData(dataBytes, pubKey.getEncoded());
        return new String(Base64.encodeBase64((byte[])encBytes), SecssConstants.CHARSET_COMM);
    }

    private String decryptDataLocal(byte[] dataBytes) throws SecurityException, Exception {
        PrivateKey priKey = this.certUtil.getPriKey();
        if (priKey == null) {
            throw new Exception("\u83b7\u53d6\u5230\u7684\u79c1\u94a5\u4e3a\u7a7a");
        }
        byte[] decBytes = SecureUtil.decryptData(dataBytes, priKey.getEncoded());
        return new String(decBytes, SecssConstants.CHARSET_COMM);
    }

    private String getSignStr(Map map, List invalidFields, boolean isSort) throws SecurityException {
        StringBuffer param = null;
        ArrayList<String> msgList = null;
        if (map == null || map.size() == 0) {
            throw new SecurityException(SecssConstants.GET_SIGN_STRING_ERROR);
        }
        try {
            param = new StringBuffer();
            msgList = new ArrayList<String>();
            for (String key : map.keySet()) {
                if (invalidFields != null && invalidFields.contains(key)) continue;
                String value = (String)map.get(key);
                msgList.add(String.valueOf(key) + SecssConstants.KEY_VALUE_CONNECT + value);
            }
            if (isSort) {
                Collections.sort(msgList);
            }
            int i = 0;
            while (i < msgList.size()) {
                String msg = (String)msgList.get(i);
                if (i > 0) {
                    param.append(SecssConstants.MESSAGE_CONNECT);
                }
                param.append(msg);
                ++i;
            }
            return param.toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u6784\u5efa\u7b7e\u540d\u5b57\u7b26\u4e32\u5f02\u5e38", e);
            throw new SecurityException(SecssConstants.GET_SIGN_STRING_ERROR);
        }
    }

    public static String cpEncryptData(String src) throws Exception {
        CPEncryptAndDecrypt ced = new CPEncryptAndDecrypt();
        byte[] resultData = null;
        try {
            resultData = ced.encryptPassword(src.getBytes(SecssConstants.CHARSET_COMM));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog("\u7f16\u7801\u5f02\u5e38", e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u52a0\u5bc6\u5f02\u5e38", e);
        }
        if (resultData == null) {
            LogUtil.writeLog("\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
            return null;
        }
        return Base64.encodeBase64String((byte[])resultData);
    }

    public static String cpDecryptData(String str) throws Exception {
        CPEncryptAndDecrypt ced = new CPEncryptAndDecrypt();
        byte[] resultData = null;
        try {
            resultData = ced.decryptPassword(Base64.decodeBase64((String)str));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog("\u7f16\u7801\u5f02\u5e38", e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u89e3\u5bc6\u5f02\u5e38", e);
        }
        if (resultData == null) {
            LogUtil.writeLog("\u89e3\u5bc6\u6570\u636e\u5931\u8d25");
            return null;
        }
        return new String(resultData, SecssConstants.CHARSET_COMM);
    }

    public void signFile(String filePath) {
        this.signFile(filePath, SecssConstants.SIGN512_ALGNAME);
    }

    /*
     * Exception decompiling
     */
    public void signFile(String filePath, String sigAlgName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String signDataBytes(byte[] dataBytes, String sigAlgName) {
        PrivateKey priKey;
        String sign;
        block5: {
            sign = null;
            priKey = this.certUtil.getPriKey();
            if (priKey != null) break block5;
            LogUtil.writeErrorLog("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
            this.errCode = SecssConstants.SIGN_GOES_WRONG;
            return null;
        }
        try {
            Signature signature = Signature.getInstance(sigAlgName);
            signature.initSign(priKey);
            signature.update(dataBytes);
            sign = new String(Base64.encodeBase64((byte[])signature.sign()));
            return sign;
        }
        catch (InvalidKeyException e) {
            LogUtil.writeErrorLog("\u79d8\u94a5\u4e0d\u6b63\u786e", e);
            this.errCode = SecssConstants.SIGN_GOES_WRONG;
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog("\u7b97\u6cd5\u4e0d\u5b58\u5728", e);
            this.errCode = SecssConstants.SIGN_GOES_WRONG;
            return null;
        }
        catch (SignatureException e) {
            LogUtil.writeErrorLog("\u9a8c\u7b7e\u5931\u8d25", e);
            this.errCode = SecssConstants.SIGN_GOES_WRONG;
            return null;
        }
    }

    public void verifyFile(String filePath) {
        this.verifyFile(filePath, SecssConstants.SIGN512_ALGNAME);
    }

    /*
     * Exception decompiling
     */
    public void verifyFile(String filePath, String sigAlgName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean verifyFile(byte[] dataBytes, byte[] signBytes, String sigAlgName) {
        PublicKey pubKey;
        boolean isSucess;
        block5: {
            isSucess = false;
            pubKey = this.certUtil.getPubKey();
            if (pubKey != null) break block5;
            LogUtil.writeErrorLog("\u83b7\u53d6\u5230\u7684\u516c\u94a5\u4e3a\u7a7a");
            this.errCode = SecssConstants.VERIFY_FAILED;
            return false;
        }
        try {
            Signature signature = Signature.getInstance(sigAlgName);
            signature.initVerify(pubKey);
            signature.update(dataBytes);
            isSucess = signature.verify(signBytes);
        }
        catch (InvalidKeyException e) {
            LogUtil.writeErrorLog("\u79d8\u94a5\u4e0d\u6b63\u786e", e);
            this.errCode = SecssConstants.VERIFY_FAILED;
            isSucess = false;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog("\u7b97\u6cd5\u4e0d\u5b58\u5728", e);
            this.errCode = SecssConstants.VERIFY_FAILED;
            isSucess = false;
        }
        catch (SignatureException e) {
            LogUtil.writeErrorLog("\u9a8c\u7b7e\u5931\u8d25", e);
            this.errCode = SecssConstants.VERIFY_FAILED;
            isSucess = false;
        }
        return isSucess;
    }

    private byte[] hashBytes(String hashAlg, byte[] dataBytes) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(hashAlg.trim());
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(dataBytes);
            byte[] buffer = new byte[4096];
            int readCount = is.read(buffer, 0, 4096);
            while (readCount != -1) {
                digest.update(buffer, 0, readCount);
                readCount = is.read(buffer, 0, 4096);
            }
            dataBytes = digest.digest();
            String base64 = Base64.encodeBase64String((byte[])dataBytes);
            LogUtil.writeLog("hash = " + base64);
            byte[] byArray = dataBytes;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public static boolean isEmpty(byte[] b) {
        return b == null || b.length < 1;
    }

    public String getSign() {
        return this.sign;
    }

    public String getEncPin() {
        return this.encPin;
    }

    public String getEncValue() {
        return this.encValue;
    }

    public String getDecValue() {
        return this.decValue;
    }

    public String getCertId() {
        return this.certId;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        this.errMsg = SecssUtil.isEmpty(this.errCode) ? (String)SecssConstants.ERRMAP.get(SecssConstants.UNKNOWN_WRONG) : (String)SecssConstants.ERRMAP.get(this.errCode);
        if (SecssUtil.isEmpty(this.errMsg)) {
            this.errMsg = (String)SecssConstants.ERRMAP.get(SecssConstants.UNKNOWN_WRONG);
        }
        return this.errMsg;
    }

    public long getHashLength() {
        return this.hashLength;
    }

    public void setHashLength(long hashLength) {
        this.hashLength = hashLength;
    }

    public static void main(String[] args) throws Exception {
        String str = "\u4f60\u597d";
        String enStr = SecssUtil.cpEncryptData(str);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u6570\u636e\uff1a" + enStr);
        String decStr = SecssUtil.cpDecryptData(enStr);
        System.out.println("\u89e3\u5bc6\u540e\u7684\u6570\u636e:" + decStr);
    }
}

