package com.bizvane.mktcenterservice.rpc;

import com.bizvane.mktcenterservice.models.bo.ActivityRegistrationBO;
import com.bizvane.mktcenterservice.models.bo.TMktActivitySignup;
import com.bizvane.mktcenterservice.models.vo.SignupHistory;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhaoxh
 */
@FeignClient(value = "${feign.client.mktcenter.name}", path = "${feign.client.mktcenter.path}/activityRegistrationRpc")
public interface ActivityRegistrationServiceRpc {
    /**
     * 查询活动详情
     */
    @RequestMapping("/detail")
    ResponseData<ActivityRegistrationBO> getActivityRegistrationDetail(@RequestParam("activityCode") String activityCode);

    @RequestMapping("/signup")
    ResponseData<Object> signup(@RequestBody TMktActivitySignup activitySignup);

    @RequestMapping("/getByActivityCodeAndPhone")
    ResponseData<List<TMktActivitySignup>> getByActivityCodeAndPhone(@RequestParam("activityCode") String activityCode, @RequestParam("phone") String phone);

    @RequestMapping("/signupHistory")
    ResponseData<List<SignupHistory>> signupHistory(@RequestParam("memberCode") String memberCode);

    @RequestMapping("/signin")
    ResponseData<Object> signin(@RequestParam("activityCode") String activityCode, @RequestParam("phone") String phone);
}
