package com.bizvane.mktcenterservice.models.newmkt;

import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @author Ljc
 */

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MktMemActivityVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 子商户号
     */
    private String subMerchantId;

    /**
     * 活动主键id
     */
    private Integer activityId;

    /**
     * 活动编号
     */
    private String taskCode;

    /**
     * 活动名称
     */
    private String taskName;

    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    private String startTime;

    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    private String endTime;

    /**
     * 活动图片地址
     */
    private String iconUrl;

    /**
     * 会员允许参加的次数默认不限次为*
     */
    private String times;

    /**
     * 活动类型 OD_MONEY_STRATEGY：满元
     */
    private String activityType;

    /**
     * 活动描述
     */
    private String description;

    /**
     * 创建人姓名
     */
    private String createUser;

    /**
     * 规则
     */
    private MktMemActivityRulesVO rules;

    /**
     * 奖励
     */
    private List<MktMemActivityRewardRuleVO> rewards;

    /**
     * 消息
     */
    private MktMemActivityNotifyVO notify;


}
