package com.bizvane.mktcenterservice.models.newmkt;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @description:
 * @author: Liu Xinpeng
 * @create: 2020-08-19 11:26
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class JobPo implements Serializable {

    /**
     * 子商户号
     */
    private String subMerchantId;

    /**
     * 业务单号id
     */
    private Long bizId;


    /**
     * 活动编号
     */
    private String taskCode;


    /**
     * 活动名称
     */
    private String taskName;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    private Date createDate;

    /**
     * 会员信息
     */
    private MktMemActivityGroupVO userGroup;


}