package com.bizvane.mktcenterservice.common;

/**
 * @Author: ljc
 * @Time: 2020/7/29 11:03
 */
public enum ActivityMemberResponseEnum {

    //该任务不存在
    ACTIVITY_TYPE_ALL("5006","该任务不存在"),
    //子商户号不存在
    ACTIVITY_TYPE_REGISGER("5005","子商户号不存在"),
    //营销异常
    ACTIVITY_TYPE_UPGRADE("5004","营销异常"),
    //入参有为空项，请检查必填项
    ACTIVITY_TYPE_QRCODE("5003","入参有为空项，请检查必填项"),
    //活动模块不存在
    ACTIVITY_TYPE_MANUAL("5002","活动模块不存在"),
    //操作失败
    ACTIVITY_TYPE_ORDER("5001","操作失败"),
    //商户信息不存在
    ACTIVITY_TYPE_SIGNIN("5000","商户信息不存在"),

    //审核
    //ALL_STATUS:全部
    AUDITING_STATUS_ALL("ALL_STATUS","全部"),
    //WAIT_STATUS:审核中
    AUDITING_STATUS_WAIT("WAIT_STATUS","审核中"),
    //PASS_STATUS:审核通过
    AUDITING_STATUS_PASS("PASS_STATUS","审核通过"),
    //FAIL_STATUS:审核不通过
    AUDITING_STATUS_FAIL("FAIL_STATUS","审核不通过"),

    //活动状态
    //TASK_ALL_STATUA:全部
    TASK_ALL_STATUA("TASK_ALL_STATUA","全部"),
    //WAIT_START_STATUS:待执行
    TASK_WAIT_START_STATUS("WAIT_START_STATUS","待执行"),
    //ONGOING_STATUS:启用中
    TASK_ONGOING_STATUS("ONGOING_STATUS","启用中"),
    //SUSPEND_STATUS:已暂停
    TASK_SUSPEND_STATUS("SUSPEND_STATUS","已暂停"),
    //CLOSED_STATUS:已结束
    TASK_CLOSED_STATUS("CLOSED_STATUS","已结束"),

    //会员筛选
    //会员分组
    MBR_GROUP_BYGROUP("byGroup","会员分组"),
    //高级筛选
    MBR_GROUP_BYDYNAMIC("byDynamic","高级筛选"),

    //商品黑白名单
    //黑名单
    ITEM_BLOCK("black","黑名单"),
    //白名单
    ITEM_WHITE("white","白名单"),

    //奖励积分类型
    //simple:整数积分
    INTEGRAL_SIMPLE("simple","整数积分"),
    //multiple:倍数积分
    INTEGRAL_MULTIPLE("multiple","倍数积分"),

    //发券类型 send_type
    //新消费活动
    SEND_COUPON_COUSUME_ACTIVITY_NEW("045", "新会员消费"),

    //MQ
    //校验订单topic
    CHECK_ORDER_RULES_MQ("CHECK_ORDER_RULES_MQ","校验订单"),
    //发送奖励topic
    SEND_ACTIVITY_REWARDS_MQ("SEND_ACTIVITY_REWARDS_MQ","发送奖励");

    private String code;
    private String message;


    ActivityMemberResponseEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static ActivityMemberResponseEnum getConvertCouponAndIntegralTypeEnumByCode(String code){
        for(ActivityMemberResponseEnum convertCouponAndIntegralTypeEnum : ActivityMemberResponseEnum.values()){
            if(code.equals(convertCouponAndIntegralTypeEnum.getCode())){
                return convertCouponAndIntegralTypeEnum;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
