package com.bizvane.members.facade.service.common;

import com.bizvane.members.facade.models.MemberInfoUpdateResponseVO;
import com.bizvane.members.facade.vo.yanzhiwu.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CommonMemberApiService {

    @PostMapping(value = "/api/yanzhiwu/openCard")
    ResponseData<MemberOpenCardResponseVo> openCard(@RequestBody @Valid MemberOpenCardRequestVo requestVo);

    @PostMapping(value = "/api/yanzhiwu/memberQuery")
    ResponseData<MemberQueryResponseVo> memberQuery(@RequestBody @Valid MemberQueryRequestVo requestVo);

}
