package com.bizvane.members.facade.enums;

public enum OpenCardSceneEnum {
	SCAN_QR_CODE(30, "扫码开卡"), BIND_CARD(20, "绑卡"), SELF_CHOOSE(10, "自选开卡门店"), DEFAULT(0, "默认开卡门店");

	private Integer code;

	private String msg;

	OpenCardSceneEnum(Integer code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public static String getOpenCardScene(String code) {
		for (OpenCardSceneEnum type : OpenCardSceneEnum.values()) {
			if (code.equals(String.valueOf(type.getCode()))) {
				return type.getMsg();
			}
		}
		return "";
	}

	public static Integer getOpenCardSceneCode(String msg) {
		for (OpenCardSceneEnum type : OpenCardSceneEnum.values()) {
			if (msg.equals(type.getMsg())) {
				return type.getCode();
			}
		}
		return 3;
	}
}
