package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/21.
 */
public enum IntegralBusinessTypeEnum {

    RESERVE("-1", "保留原积分"),

    EMPTY("0", "积分过期"),

    ADJUST_EXPEND("1", "手动调整支出"),

    ADJUST_INCOME("2", "手动调整获取"),

    TASK_INCOME("3", "任务完成获取"),

    CONSUME_INCOME("4", "商品消费获取"),

    ACTIVITY_INCOME("5", "活动赠送获取"),

    EXCHANGE_EXPEND("6", "积分兑换支出"),

    GAME_EXPEND("7", "游戏消耗支出");


    IntegralBusinessTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private String code;

    private String msg;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static IntegralBusinessTypeEnum getIntegralRecordTypeEnum(String code) {
        for (IntegralBusinessTypeEnum type : IntegralBusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getIntegralBusinessMessage(String code) {
        for (IntegralBusinessTypeEnum businessTypeEnum : IntegralBusinessTypeEnum.values()) {
            if (code.equals(businessTypeEnum.getCode())) {
                return businessTypeEnum.getMsg();
            }
        }
        return "";
    }
}
