package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrOrderApiService {

    @RequestMapping(value = "/api/urOrder/getUrOrderRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<MiniUrOrderResponseVo>> getUrOrderRecord(@RequestBody @Valid MiniUrOrderRequestVo miniUrOrderRequestVo);

    /**
     * 保存订单信息
     *
     * @param urSaveOrderRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urOrder/saveOrderForm", method = RequestMethod.POST)
    ResponseData<String> saveOrderForm(@RequestBody @Valid UrSaveOrderRequestVo urSaveOrderRequestVo);

    /**
     * 查询订单信息
     *
     * @param urOrderQueryRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urOrder/queryOrderInfo", method = RequestMethod.POST)
    ResponseData<PageInfo<UrOrderQueryResponseVo>> queryOrderInfo(@RequestBody @Valid UrOrderQueryRequestVo urOrderQueryRequestVo);


    @RequestMapping(value = "/api/urOrder/updateOrderEvaluate", method = RequestMethod.POST)
    ResponseData<Integer> updateOrderEvaluate(@RequestBody @Valid UrOrderUpdateVo urOrderUpdateVo);

    /**
     * UR小程序查询 储蓄卡消费记录
     * @param memberCode
     * @param pageNumber
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "/api/urOrder/queryRechargeCardConsumeRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<UrRechargeConsumeRecordResVo>> queryRechargeCardConsumeRecord(@RequestParam("memberCode") @NotEmpty String memberCode,
                                                                                        @RequestParam("sysCompanyId") @NotEmpty Long sysCompanyId,
                                                            @RequestParam("pageNumber") @NotEmpty Integer pageNumber,
                                                            @RequestParam(value = "pageSize",defaultValue = "10")Integer pageSize);

    /**
     * ur小程序查询消费记录详情
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/urOrder/queryRechargeCardConsumeRecordDetail", method = RequestMethod.POST)
    ResponseData<UrRechargeConsumeRecordDetailResVo> queryRechargeCardConsumeRecordDetail(@RequestBody UrRechargeConsumeRecordDetailReqVo vo);

    /**
     * ur会员消费历史统计
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/urOrder/consumeStatistics", method = RequestMethod.POST)
    ResponseData<UrConsumeStatisticsResVo> consumeStatistics(@RequestBody UrConsumeStatisticsReqVo vo);


    /**
     * 会员订单信息查询
     */
    @RequestMapping(value = "/api/urOrder/queryOrderList", method = RequestMethod.POST)
    ResponseData<PageInfo<UrSaveOrderRequestVo>> queryOrderList(@RequestBody @Valid UrQueryOrderListRequestVo requestVo);
}
