package com.bizvane.customized.facade.interfaces;

import com.bizvane.customized.facade.models.po.CusTeddyGoodsCodeDetailPO;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.customized.name}", path = "${feign.client.customized.path}/teddy/goodsCode")
public interface CusTeddyGoodsServiceFeign {

    /**
     * 商品码校验
     * @param cusTeddyGoodsVo
     * 调用方：applet
     * @return
     */
    @PostMapping(value = "verify")
    public ResponseData verify(@RequestBody CusTeddyGoodsVo cusTeddyGoodsVo);


    /**
     * 根据code查询商品码信息
     * @param cusTeddyGoodsVo
     * 调用方：applet
     * @return
     */
    @PostMapping(value = "detail")
    public ResponseData<CusTeddyGoodsCodeDetailPO> detail(@RequestBody CusTeddyGoodsVo cusTeddyGoodsVo);

}
