/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorNot
extends SpelNodeImpl {
    public OperatorNot(int pos, SpelNodeImpl operand) {
        super(pos, operand);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        try {
            Boolean value = this.children[0].getValue(state, Boolean.class);
            if (value == null) {
                throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
            }
            return BooleanTypedValue.forValue(value == false);
        }
        catch (SpelEvaluationException ex) {
            ex.setPosition(this.getChild(0).getStartPosition());
            throw ex;
        }
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("!").append(this.getChild(0).toStringAST());
        return sb.toString();
    }
}

