/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.impl.ParameterMarkerExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.LimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;
import org.apache.shardingsphere.sql.parser.util.SQLUtil;

public final class LimitExtractor
implements OptionalSQLSegmentExtractor {
    private final ParameterMarkerExpressionExtractor parameterMarkerExpressionExtractor = new ParameterMarkerExpressionExtractor();

    public Optional<LimitSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> limitNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.LIMIT_CLAUSE);
        return limitNode.isPresent() ? Optional.of((Object)new LimitSegment(((ParserRuleContext)limitNode.get()).getStart().getStartIndex(), ((ParserRuleContext)limitNode.get()).getStop().getStopIndex(), (PaginationValueSegment)this.extractOffset((ParserRuleContext)limitNode.get(), parameterMarkerIndexes).orNull(), (PaginationValueSegment)this.extractRowCount((ParserRuleContext)limitNode.get(), parameterMarkerIndexes).orNull())) : Optional.absent();
    }

    private Optional<LimitValueSegment> extractOffset(ParserRuleContext limitNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> offsetNode = ExtractorUtils.findFirstChildNode(limitNode, RuleName.LIMIT_OFFSET);
        return offsetNode.isPresent() ? Optional.of((Object)this.extractLimitValue((ParserRuleContext)offsetNode.get(), parameterMarkerIndexes)) : Optional.absent();
    }

    private Optional<LimitValueSegment> extractRowCount(ParserRuleContext limitNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> rowCountNode = ExtractorUtils.findFirstChildNode(limitNode, RuleName.LIMIT_ROW_COUNT);
        return rowCountNode.isPresent() ? Optional.of((Object)this.extractLimitValue((ParserRuleContext)rowCountNode.get(), parameterMarkerIndexes)) : Optional.absent();
    }

    private LimitValueSegment extractLimitValue(ParserRuleContext limitValueNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParameterMarkerExpressionSegment> parameterMarkerExpression = this.parameterMarkerExpressionExtractor.extract(limitValueNode, parameterMarkerIndexes);
        if (parameterMarkerExpression.isPresent()) {
            return new ParameterMarkerLimitValueSegment(limitValueNode.getStart().getStartIndex(), limitValueNode.getStop().getStopIndex(), ((ParameterMarkerExpressionSegment)parameterMarkerExpression.get()).getParameterMarkerIndex());
        }
        Optional<ParserRuleContext> numberLiteralsNode = ExtractorUtils.findFirstChildNode(limitValueNode, RuleName.NUMBER_LITERALS);
        Preconditions.checkState((boolean)numberLiteralsNode.isPresent());
        return new NumberLiteralLimitValueSegment(limitValueNode.getStart().getStartIndex(), limitValueNode.getStop().getStopIndex(), SQLUtil.getExactlyNumber(((ParserRuleContext)numberLiteralsNode.get()).getText(), 10).longValue());
    }
}

