/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.jaxrs.ParsingException;
import java.util.Set;
import javax.validation.ConstraintViolation;

public class BeanValidationException
extends ParsingException {
    private final Set<ConstraintViolation<Object>> violations;

    public BeanValidationException(Set<ConstraintViolation<Object>> violations) {
        super(Joiner.on((String)", ").join(Iterables.transform(violations, BeanValidationException.constraintMessageBuilder())));
        this.violations = ImmutableSet.copyOf(violations);
    }

    public Set<ConstraintViolation<Object>> getViolations() {
        return this.violations;
    }

    public static <T> Function<ConstraintViolation<T>, String> constraintMessageBuilder() {
        return violation -> violation.getPropertyPath().toString() + " " + violation.getMessage();
    }
}

