/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.spi;

import com.sun.btrace.api.BTraceCompiler;
import com.sun.btrace.api.BTraceTask;
import com.sun.btrace.compiler.Compiler;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseBTraceCompiler
extends BTraceCompiler {
    private static final Logger LOGGER = Logger.getLogger(BTraceCompiler.class.getName());
    private static final Pattern classNamePattern = Pattern.compile("@BTrace\\s*.+?\\s*class\\s*(.*?)\\s+\\{", 41);
    private final Compiler c;
    private final BTraceTask task;
    private final Object toolsJarLock = new Object();
    private String toolsJar = null;
    private final Object jarBaseDirLock = new Object();
    private String jarBaseDir = null;

    public BaseBTraceCompiler(BTraceTask task) {
        this.c = new Compiler(null, task.isUnsafe());
        this.task = task;
    }

    @Override
    public byte[] compile(String source, String classPath, Writer errorWriter) {
        try {
            Matcher matcher = classNamePattern.matcher(source);
            if (matcher.find()) {
                String completeCP;
                String fileName;
                Map<String, byte[]> compilationMap;
                if (errorWriter == null) {
                    errorWriter = new PrintWriter(System.out);
                }
                if ((compilationMap = this.c.compile(fileName = matcher.group(1) + ".java", source, errorWriter, ".", completeCP = this.getToolsJarPath() + File.pathSeparator + this.getClientJarPath() + File.pathSeparator + classPath)) != null) {
                    return compilationMap.values().iterator().next();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
        return new byte[0];
    }

    @Override
    public String getAgentJarPath() {
        return this.getJarBaseDir() + File.separatorChar + "btrace-agent.jar";
    }

    @Override
    public String getClientJarPath() {
        return this.getJarBaseDir() + File.separatorChar + "btrace-client.jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolsJarPath() {
        Object object = this.toolsJarLock;
        synchronized (object) {
            if (this.toolsJar == null) {
                String javaHome = BaseBTraceCompiler.getJavaHome(this.task);
                if (javaHome == null) {
                    File toolsJarFile = this.getContainingJar("com/sun/tools/javac/Main.class");
                    if (toolsJarFile != null) {
                        this.toolsJar = toolsJarFile.getAbsolutePath();
                    }
                } else {
                    File toolsJarFile = new File(javaHome + "/lib/tools.jar");
                    this.toolsJar = toolsJarFile.exists() ? toolsJarFile.getAbsolutePath() : ((toolsJarFile = new File(javaHome + "/../lib/tools.jar")).exists() ? toolsJarFile.getAbsolutePath() : ((toolsJarFile = new File(javaHome + "/../Classes/classes.jar")).exists() ? toolsJarFile.getAbsolutePath() : ""));
                }
            }
            return this.toolsJar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJarBaseDir() {
        Object object = this.jarBaseDirLock;
        synchronized (object) {
            if (this.jarBaseDir == null) {
                File f;
                for (f = this.getContainingJar("com/sun/btrace/BTraceRuntime.class"); !(f == null || f.exists() && f.isDirectory()); f = f.getParentFile()) {
                }
                if (f != null) {
                    this.jarBaseDir = f.getAbsolutePath();
                }
            }
            return this.jarBaseDir;
        }
    }

    private File getContainingJar(String clz) {
        File jarFile;
        String path;
        int index;
        URL url = this.getClass().getClassLoader().getResource(clz);
        if ("jar".equals(url.getProtocol()) && (index = (path = url.getPath()).indexOf("!/")) >= 0) {
            try {
                String jarPath = path.substring(0, index);
                if (jarPath.indexOf("file://") > -1 && jarPath.indexOf("file:////") == -1) {
                    jarPath = jarPath.replaceFirst("file://", "file:////");
                }
                url = new URL(jarPath);
            }
            catch (MalformedURLException mue) {
                throw new RuntimeException(mue);
            }
        }
        try {
            jarFile = new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        assert (jarFile.exists());
        return jarFile;
    }

    private static String getJavaHome(BTraceTask btt) {
        try {
            VirtualMachine vm = VirtualMachine.attach(String.valueOf(btt.getPid()));
            return vm.getSystemProperties().getProperty("java.home");
        }
        catch (AttachNotSupportedException e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
        return null;
    }
}

