/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.compiler;

import com.sun.btrace.compiler.PCPP;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class MemoryJavaFileManager
extends ForwardingJavaFileManager {
    private List<String> includeDirs;
    private Map<String, byte[]> classBytes;

    public MemoryJavaFileManager(JavaFileManager fileManager, List<String> includeDirs) {
        super(fileManager);
        this.includeDirs = includeDirs;
        this.classBytes = new HashMap<String, byte[]>();
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }

    @Override
    public void close() throws IOException {
        this.classBytes = new HashMap<String, byte[]>();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            return new ClassOutputBuffer(className);
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject result = super.getJavaFileForInput(location, className, kind);
        if (kind == JavaFileObject.Kind.SOURCE) {
            return MemoryJavaFileManager.preprocessedFileObject(result, this.includeDirs);
        }
        return result;
    }

    static JavaFileObject preprocessedFileObject(JavaFileObject fo, List<String> includeDirs) throws IOException {
        if (includeDirs != null) {
            PCPP pcpp = new PCPP(includeDirs);
            StringWriter out = new StringWriter();
            pcpp.setOut(out);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fo.openInputStream()));
            pcpp.run(reader, fo.getName());
            return new StringInputBuffer(fo.getName(), out.toString());
        }
        return fo;
    }

    static JavaFileObject makeStringSource(String name, String code, List<String> includeDirs) {
        if (includeDirs != null) {
            PCPP pcpp = new PCPP(includeDirs);
            StringWriter out = new StringWriter();
            pcpp.setOut(out);
            try {
                pcpp.run(new StringReader(code), name);
            }
            catch (IOException exp) {
                throw new RuntimeException(exp);
            }
            return new StringInputBuffer(name, out.toString());
        }
        return new StringInputBuffer(name, code);
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            return URI.create("mfm:///" + name);
        }
        catch (Exception exp) {
            return URI.create("mfm:///com/sun/script/java/java_source");
        }
    }

    private class ClassOutputBuffer
    extends SimpleJavaFileObject {
        private String name;

        ClassOutputBuffer(String name) {
            super(MemoryJavaFileManager.toURI(name), JavaFileObject.Kind.CLASS);
            this.name = name;
        }

        @Override
        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                @Override
                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    MemoryJavaFileManager.this.classBytes.put(ClassOutputBuffer.this.name, bos.toByteArray());
                }
            };
        }
    }

    private static class StringInputBuffer
    extends SimpleJavaFileObject {
        final String code;

        StringInputBuffer(String name, String code) {
            super(MemoryJavaFileManager.toURI(name), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) {
            return CharBuffer.wrap(this.code);
        }

        public Reader openReader() {
            return new StringReader(this.code);
        }
    }
}

