/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.api.impl;

import com.sun.btrace.CommandListener;
import com.sun.btrace.api.BTraceCompiler;
import com.sun.btrace.api.BTraceEngine;
import com.sun.btrace.api.BTraceSettings;
import com.sun.btrace.api.BTraceTask;
import com.sun.btrace.api.impl.BTraceTaskImpl;
import com.sun.btrace.client.Client;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.ErrorCommand;
import com.sun.btrace.comm.RetransformationStartNotification;
import com.sun.btrace.spi.BTraceCompilerFactory;
import com.sun.btrace.spi.BTraceSettingsProvider;
import com.sun.btrace.spi.ClasspathProvider;
import com.sun.btrace.spi.OutputProvider;
import com.sun.btrace.spi.PortLocator;
import com.sun.btrace.spi.impl.BTraceCompilerFactoryImpl;
import com.sun.btrace.spi.impl.BTraceSettingsProviderImpl;
import com.sun.btrace.spi.impl.PortLocatorImpl;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BTraceEngineImpl
extends BTraceEngine {
    private static final Logger LOGGER = Logger.getLogger(BTraceEngineImpl.class.getName());
    private BTraceSettingsProvider settingsProvider;
    private BTraceCompilerFactory compilerFactory;
    private ClasspathProvider cpProvider;
    private PortLocator portLocator;
    private OutputProvider outputProvider;
    private Map<BTraceTask, Client> clientMap = new HashMap<BTraceTask, Client>();
    private final Set<WeakReference<StateListener>> listeners = new HashSet<WeakReference<StateListener>>();
    private final ExecutorService commQueue = Executors.newCachedThreadPool();
    private final AtomicBoolean stopping = new AtomicBoolean(false);

    public BTraceEngineImpl() {
        this.settingsProvider = BTraceEngineImpl.initSettingsProvider();
        this.compilerFactory = BTraceEngineImpl.initCompilerFactory();
        this.cpProvider = BTraceEngineImpl.initClasspathProvider();
        this.portLocator = BTraceEngineImpl.initPortLocator();
        this.outputProvider = BTraceEngineImpl.initOutputProvider();
    }

    private static BTraceCompilerFactory initCompilerFactory() {
        Iterator<BTraceCompilerFactory> iter;
        ServiceLoader<BTraceCompilerFactory> loader = ServiceLoader.load(BTraceCompilerFactory.class);
        if (loader != null && (iter = loader.iterator()).hasNext()) {
            return iter.next();
        }
        return new BTraceCompilerFactoryImpl();
    }

    private static ClasspathProvider initClasspathProvider() {
        Iterator<ClasspathProvider> iter;
        ServiceLoader<ClasspathProvider> loader = ServiceLoader.load(ClasspathProvider.class);
        if (loader != null && (iter = loader.iterator()).hasNext()) {
            return iter.next();
        }
        return ClasspathProvider.EMPTY;
    }

    private static BTraceSettingsProvider initSettingsProvider() {
        Iterator<BTraceSettingsProvider> iter;
        ServiceLoader<BTraceSettingsProvider> loader = ServiceLoader.load(BTraceSettingsProvider.class);
        if (loader != null && (iter = loader.iterator()).hasNext()) {
            return iter.next();
        }
        return new BTraceSettingsProviderImpl();
    }

    private static PortLocator initPortLocator() {
        Iterator<PortLocator> iter;
        ServiceLoader<PortLocator> loader = ServiceLoader.load(PortLocator.class);
        if (loader != null && (iter = loader.iterator()).hasNext()) {
            return iter.next();
        }
        return new PortLocatorImpl();
    }

    private static OutputProvider initOutputProvider() {
        Iterator<OutputProvider> iter;
        ServiceLoader<OutputProvider> loader = ServiceLoader.load(OutputProvider.class);
        if (loader != null && (iter = loader.iterator()).hasNext()) {
            return iter.next();
        }
        return OutputProvider.DEFAULT;
    }

    @Override
    public BTraceTask createTask(int pid) {
        return new BTraceTaskImpl(pid, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(StateListener listener) {
        Set<WeakReference<StateListener>> set = this.listeners;
        synchronized (set) {
            this.listeners.add(new WeakReference<StateListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(StateListener listener) {
        Set<WeakReference<StateListener>> set = this.listeners;
        synchronized (set) {
            Iterator<WeakReference<StateListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<StateListener> ref = iter.next();
                StateListener l = (StateListener)ref.get();
                if (l != null && !l.equals(listener)) continue;
                iter.remove();
            }
        }
    }

    boolean start(BTraceTask task) {
        LOGGER.finest("Starting BTrace task");
        boolean result = this.doStart(task);
        LOGGER.log(Level.FINEST, "BTrace task {0}", result ? "started successfuly" : "failed");
        if (result) {
            this.fireOnTaskStart(task);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean stop(BTraceTask task) {
        LOGGER.finest("Attempting to stop BTrace task");
        try {
            if (this.stopping.compareAndSet(false, true)) {
                LOGGER.finest("Stopping BTrace task");
                boolean result = this.doStop(task);
                LOGGER.log(Level.FINEST, "BTrace task {0}", result ? "stopped successfuly" : "not stopped");
                if (result) {
                    this.fireOnTaskStop(task);
                }
                boolean bl = result;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.stopping.set(false);
        }
    }

    private boolean doStart(BTraceTask task) {
        final AtomicBoolean result = new AtomicBoolean(false);
        final BTraceTaskImpl btrace = (BTraceTaskImpl)task;
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final BTraceCompiler compiler = this.compilerFactory.newCompiler(btrace);
            btrace.setState(BTraceTask.State.COMPILING);
            final byte[] bytecode = compiler.compile(btrace.getScript(), task.getClassPath(), this.outputProvider.getStdErr(task));
            if (bytecode.length == 0) {
                btrace.setState(BTraceTask.State.FAILED);
                return false;
            }
            btrace.setState(BTraceTask.State.COMPILED);
            LOGGER.log(Level.FINEST, "Compiled the trace: {0} bytes", bytecode.length);
            this.commQueue.submit(new Runnable(){

                @Override
                public void run() {
                    int port = BTraceEngineImpl.this.portLocator.getTaskPort(btrace);
                    LOGGER.log(Level.FINEST, "BTrace agent listening on port {0}", port);
                    BTraceSettings settings = BTraceEngineImpl.this.settingsProvider.getSettings();
                    final Client client = new Client(port, ".", settings.isDebugMode(), true, btrace.isUnsafe(), settings.isDumpClasses(), settings.getDumpClassPath());
                    try {
                        client.attach(String.valueOf(btrace.getPid()), compiler.getAgentJarPath(), compiler.getToolsJarPath(), null);
                        Thread.sleep(200L);
                        client.submit(bytecode, new String[0], new CommandListener(){

                            @Override
                            public void onCommand(Command cmd) throws IOException {
                                LOGGER.log(Level.FINEST, "Received command: {0}", cmd.toString());
                                switch (cmd.getType()) {
                                    case 6: {
                                        if (btrace.getState() == BTraceTask.State.COMPILED) {
                                            btrace.setState(BTraceTask.State.ACCEPTED);
                                            break;
                                        }
                                        if (!EnumSet.of(BTraceTask.State.INSTRUMENTING, BTraceTask.State.ACCEPTED).contains((Object)btrace.getState())) break;
                                        btrace.setState(BTraceTask.State.RUNNING);
                                        result.set(true);
                                        BTraceEngineImpl.this.clientMap.put(btrace, client);
                                        latch.countDown();
                                        break;
                                    }
                                    case 2: {
                                        btrace.setState(BTraceTask.State.FINISHED);
                                        latch.countDown();
                                        BTraceEngineImpl.this.stop(btrace);
                                        break;
                                    }
                                    case 11: {
                                        int numClasses = ((RetransformationStartNotification)cmd).getNumClasses();
                                        btrace.setInstrClasses(numClasses);
                                        btrace.setState(BTraceTask.State.INSTRUMENTING);
                                        break;
                                    }
                                    case 0: {
                                        ((ErrorCommand)cmd).getCause().printStackTrace(BTraceEngineImpl.this.outputProvider.getStdErr(btrace));
                                        btrace.setState(BTraceTask.State.FAILED);
                                        latch.countDown();
                                        BTraceEngineImpl.this.stop(btrace);
                                    }
                                }
                                btrace.dispatchCommand(cmd);
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        result.set(false);
                        latch.countDown();
                    }
                }
            });
            latch.await();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return result.get();
    }

    private boolean doStop(BTraceTask task) {
        Client client = this.clientMap.remove(task);
        if (client != null) {
            try {
                client.sendExit(0);
                Thread.sleep(300L);
                client.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    void sendEvent(BTraceTaskImpl task) {
        Client client = this.clientMap.get(task);
        if (client != null) {
            try {
                client.sendEvent();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    void sendEvent(BTraceTaskImpl task, String eventName) {
        Client client = this.clientMap.get(task);
        if (client != null) {
            try {
                client.sendEvent(eventName);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    ClasspathProvider getClasspathProvider() {
        return this.cpProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOnTaskStart(BTraceTask task) {
        Set<WeakReference<StateListener>> set = this.listeners;
        synchronized (set) {
            for (WeakReference<StateListener> ref : this.listeners) {
                StateListener l = (StateListener)ref.get();
                if (l == null) continue;
                l.onTaskStart(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOnTaskStop(BTraceTask task) {
        Set<WeakReference<StateListener>> set = this.listeners;
        synchronized (set) {
            for (WeakReference<StateListener> ref : this.listeners) {
                StateListener l = (StateListener)ref.get();
                if (l == null) continue;
                l.onTaskStop(task);
            }
        }
    }

    static interface StateListener
    extends EventListener {
        public void onTaskStart(BTraceTask var1);

        public void onTaskStop(BTraceTask var1);
    }
}

