/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc.codec;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DoubleToDecimalCodec
extends TypeCodec<Double> {
    public DoubleToDecimalCodec(Class<Double> javaClass) {
        super(DataType.decimal(), javaClass);
    }

    public ByteBuffer serialize(Double paramT, ProtocolVersion paramProtocolVersion) throws InvalidTypeException {
        if (paramT == null) {
            return null;
        }
        return ByteBufferUtil.bytes((double)paramT);
    }

    public Double deserialize(ByteBuffer paramByteBuffer, ProtocolVersion paramProtocolVersion) throws InvalidTypeException {
        if (paramByteBuffer == null) {
            return null;
        }
        Float value = Float.valueOf(ByteBufferUtil.toFloat((ByteBuffer)paramByteBuffer.duplicate()));
        return value.doubleValue();
    }

    public Double parse(String paramString) throws InvalidTypeException {
        return Double.valueOf(paramString);
    }

    public String format(Double paramT) throws InvalidTypeException {
        return String.valueOf(paramT);
    }
}

