/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc.codec;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class BigDecimalToBigintCodec
extends TypeCodec<BigDecimal> {
    public BigDecimalToBigintCodec(Class<BigDecimal> javaClass) {
        super(DataType.bigint(), javaClass);
    }

    public ByteBuffer serialize(BigDecimal paramT, ProtocolVersion paramProtocolVersion) throws InvalidTypeException {
        if (paramT == null) {
            return null;
        }
        return ByteBufferUtil.bytes((long)paramT.longValue());
    }

    public BigDecimal deserialize(ByteBuffer paramByteBuffer, ProtocolVersion paramProtocolVersion) throws InvalidTypeException {
        if (paramByteBuffer == null) {
            return null;
        }
        Long value = ByteBufferUtil.toLong((ByteBuffer)paramByteBuffer.duplicate());
        return new BigDecimal(value);
    }

    public BigDecimal parse(String paramString) throws InvalidTypeException {
        return BigDecimal.valueOf(Long.valueOf(paramString));
    }

    public String format(BigDecimal paramT) throws InvalidTypeException {
        return String.valueOf(paramT);
    }
}

