/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.CassandraConnection;
import com.github.adejanovski.cassandra.jdbc.CassandraPreparedStatement;
import com.github.adejanovski.cassandra.jdbc.ManagedConnection;
import com.github.adejanovski.cassandra.jdbc.ManagedPreparedStatement;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PooledCassandraConnection
implements PooledConnection {
    private static final Logger logger = LoggerFactory.getLogger(PooledCassandraConnection.class);
    private CassandraConnection physicalConnection;
    volatile Set<ConnectionEventListener> connectionEventListeners = new HashSet<ConnectionEventListener>();
    volatile Set<StatementEventListener> statementEventListeners = new HashSet<StatementEventListener>();
    private Map<String, Set<CassandraPreparedStatement>> freePreparedStatements = new HashMap<String, Set<CassandraPreparedStatement>>();
    private Map<String, Set<CassandraPreparedStatement>> usedPreparedStatements = new HashMap<String, Set<CassandraPreparedStatement>>();

    public PooledCassandraConnection(CassandraConnection physicalConnection) {
        this.physicalConnection = physicalConnection;
    }

    @Override
    public CassandraConnection getConnection() {
        return this.physicalConnection;
    }

    @Override
    public void close() throws SQLException {
        this.physicalConnection.close();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }

    void connectionClosed() {
        ConnectionEvent event = new ConnectionEvent(this);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionClosed(event);
        }
    }

    void connectionErrorOccurred(SQLException sqlException) {
        ConnectionEvent event = new ConnectionEvent(this, sqlException);
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            listener.connectionErrorOccurred(event);
        }
    }

    void statementClosed(CassandraPreparedStatement preparedStatement) {
        StatementEvent event = new StatementEvent(this, preparedStatement);
        for (StatementEventListener listener : this.statementEventListeners) {
            listener.statementClosed(event);
        }
        String cql = preparedStatement.getCql();
        Set<CassandraPreparedStatement> freeStatements = this.freePreparedStatements.get(cql);
        Set<CassandraPreparedStatement> usedStatements = this.usedPreparedStatements.get(cql);
        usedStatements.remove(preparedStatement);
        preparedStatement.resetResults();
        try {
            preparedStatement.clearParameters();
            freeStatements.add(preparedStatement);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }

    void statementErrorOccurred(CassandraPreparedStatement preparedStatement, SQLException sqlException) {
        StatementEvent event = new StatementEvent(this, preparedStatement, sqlException);
        for (StatementEventListener listener : this.statementEventListeners) {
            listener.statementErrorOccurred(event);
        }
        String cql = preparedStatement.getCql();
        Set<CassandraPreparedStatement> usedStatements = this.usedPreparedStatements.get(cql);
        if (!(event.getSQLException() instanceof SQLRecoverableException)) {
            preparedStatement.close();
            usedStatements.remove(preparedStatement);
        }
    }

    public synchronized ManagedPreparedStatement prepareStatement(ManagedConnection managedConnection, String cql) throws SQLException {
        CassandraPreparedStatement managedPreparedStatement;
        if (!this.freePreparedStatements.containsKey(cql)) {
            this.freePreparedStatements.put(cql, new HashSet());
            this.usedPreparedStatements.put(cql, new HashSet());
        }
        Set<CassandraPreparedStatement> freeStatements = this.freePreparedStatements.get(cql);
        Set<CassandraPreparedStatement> usedStatements = this.usedPreparedStatements.get(cql);
        if (freeStatements.isEmpty()) {
            managedPreparedStatement = this.physicalConnection.prepareStatement(cql);
        } else {
            managedPreparedStatement = freeStatements.iterator().next();
            freeStatements.remove(managedPreparedStatement);
        }
        usedStatements.add(managedPreparedStatement);
        return new ManagedPreparedStatement(this, managedConnection, managedPreparedStatement);
    }
}

