/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.AbstractJdbcType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class JdbcDecimal
extends AbstractJdbcType<BigDecimal> {
    public static final JdbcDecimal instance = new JdbcDecimal();

    JdbcDecimal() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(BigDecimal obj) {
        return obj.scale();
    }

    @Override
    public int getPrecision(BigDecimal obj) {
        return obj.precision();
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(BigDecimal obj) {
        return obj.toPlainString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    public String getString(ByteBuffer bytes) {
        if (bytes == null) {
            return "null";
        }
        if (bytes.remaining() == 0) {
            return "empty";
        }
        return this.compose(bytes).toPlainString();
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }

    @Override
    public int getJdbcType() {
        return 3;
    }

    @Override
    public BigDecimal compose(Object value) {
        return (BigDecimal)value;
    }

    @Override
    public Object decompose(BigDecimal value) {
        return value;
    }
}

