/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.github.adejanovski.cassandra.jdbc.AbstractStatement;
import com.github.adejanovski.cassandra.jdbc.CassandraConnection;
import com.github.adejanovski.cassandra.jdbc.CassandraResultSet;
import com.github.adejanovski.cassandra.jdbc.CassandraStatementExtras;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStatement
extends AbstractStatement
implements CassandraStatementExtras,
Comparable<Object>,
Statement {
    public static final int MAX_ASYNC_QUERIES = 1000;
    public static final String semiColonRegex = ";";
    private static final Logger logger = LoggerFactory.getLogger(CassandraStatement.class);
    protected CassandraConnection connection;
    protected String cql;
    protected ArrayList<String> batchQueries;
    protected int fetchDirection = 1000;
    protected int fetchSize = 100;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = 1;
    protected java.sql.ResultSet currentResultSet = null;
    protected int updateCount = -1;
    protected boolean escapeProcessing = true;
    protected com.datastax.driver.core.Statement statement;
    protected ConsistencyLevel consistencyLevel;

    CassandraStatement(CassandraConnection con) throws SQLException {
        this(con, null, 1003, 1007, 1);
    }

    CassandraStatement(CassandraConnection con, String cql) throws SQLException {
        this(con, cql, 1003, 1007, 1);
    }

    CassandraStatement(CassandraConnection con, String cql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(con, cql, resultSetType, resultSetConcurrency, 1);
    }

    CassandraStatement(CassandraConnection con, String cql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = con;
        this.cql = cql;
        this.batchQueries = Lists.newArrayList();
        this.consistencyLevel = con.defaultConsistencyLevel;
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLSyntaxErrorException("the argument for result set type : %s is not a valid value");
        }
        this.resultSetType = resultSetType;
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLSyntaxErrorException("the argument for result set type : %s is not a valid value");
        }
        this.resultSetConcurrency = resultSetConcurrency;
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLSyntaxErrorException("the argument for result set holdability : %s is not a valid value");
        }
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public void addBatch(String query) throws SQLException {
        this.checkNotClosed();
        this.batchQueries.add(query);
    }

    protected final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("method was called on a closed Statement");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        this.batchQueries = new ArrayList();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        this.connection = null;
        this.cql = null;
    }

    private void doExecute(String cql) throws SQLException {
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        try {
            String[] cqlQueries = cql.split(semiColonRegex);
            if (!(cqlQueries.length <= 1 || cql.trim().toLowerCase().startsWith("begin") && cql.toLowerCase().contains("batch") && cql.toLowerCase().contains("apply"))) {
                ArrayList results = Lists.newArrayList();
                if ((double)cqlQueries.length > 1100.0) {
                    throw new SQLNonTransientException("Too many queries at once (" + cqlQueries.length + "). You must split your queries into more batches !");
                }
                StringBuilder prevCqlQuery = new StringBuilder();
                for (String cqlQuery : cqlQueries) {
                    if (cqlQuery.contains("'") && (StringUtils.countMatches((String)cqlQuery, (String)"'") % 2 == 1 && prevCqlQuery.length() == 0 || StringUtils.countMatches((String)cqlQuery, (String)"'") % 2 == 0 && prevCqlQuery.length() > 0) || prevCqlQuery.toString().length() > 0 && !cqlQuery.contains("'")) {
                        prevCqlQuery.append(cqlQuery + semiColonRegex);
                        continue;
                    }
                    prevCqlQuery.append(cqlQuery);
                    if (logger.isTraceEnabled() || this.connection.debugMode) {
                        logger.debug("CQL:: " + prevCqlQuery.toString());
                    }
                    SimpleStatement stmt = new SimpleStatement(prevCqlQuery.toString());
                    stmt.setConsistencyLevel(this.connection.defaultConsistencyLevel);
                    stmt.setFetchSize(this.fetchSize);
                    ResultSetFuture resultSetFuture = this.connection.getSession().executeAsync((com.datastax.driver.core.Statement)stmt);
                    futures.add(resultSetFuture);
                    prevCqlQuery = new StringBuilder();
                }
                for (ResultSetFuture future : futures) {
                    ResultSet rows = future.getUninterruptibly();
                    results.add(rows);
                }
                this.currentResultSet = new CassandraResultSet(this, results);
            } else {
                if (logger.isTraceEnabled() || this.connection.debugMode) {
                    logger.debug("CQL:: " + cql);
                }
                SimpleStatement stmt = new SimpleStatement(cql);
                stmt.setConsistencyLevel(this.connection.defaultConsistencyLevel);
                stmt.setFetchSize(this.fetchSize);
                this.currentResultSet = new CassandraResultSet(this, this.connection.getSession().execute((com.datastax.driver.core.Statement)stmt));
            }
        }
        catch (Exception e) {
            for (ResultSetFuture future : futures) {
                try {
                    future.cancel(true);
                }
                catch (Exception exception) {}
            }
            throw new SQLTransientException(e);
        }
    }

    @Override
    public boolean execute(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        return this.currentResultSet != null;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLSyntaxErrorException("auto key generation value of : %s is illegal");
        }
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("the Cassandra implementation does not currently support returning generated  keys");
        }
        return this.execute(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] returnCounts = new int[this.batchQueries.size()];
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        if (logger.isTraceEnabled() || this.connection.debugMode) {
            logger.debug("CQL statements: " + this.batchQueries.size());
        }
        for (String q : this.batchQueries) {
            if (logger.isTraceEnabled() || this.connection.debugMode) {
                logger.debug("CQL: " + q);
            }
            SimpleStatement stmt = new SimpleStatement(q);
            stmt.setConsistencyLevel(this.connection.defaultConsistencyLevel);
            ResultSetFuture resultSetFuture = this.connection.getSession().executeAsync((com.datastax.driver.core.Statement)stmt);
            futures.add(resultSetFuture);
        }
        int i = 0;
        for (ResultSetFuture future : futures) {
            future.getUninterruptibly();
            returnCounts[i] = 1;
            ++i;
        }
        return returnCounts;
    }

    @Override
    public java.sql.ResultSet executeQuery(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        if (this.currentResultSet == null) {
            throw new SQLNonTransientException("No ResultSet returned from the CQL statement passed in an 'executeQuery()' method");
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("auto key generation value of : %s is illegal");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkNotClosed();
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkNotClosed();
        this.resetResults();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        switch (current) {
            case 1: {
                this.resetResults();
                break;
            }
            case 2: 
            case 3: {
                throw new SQLFeatureNotSupportedException("the Cassandra implementation does not currently support multiple open Result Sets");
            }
            default: {
                throw new SQLSyntaxErrorException(String.format("the argument for keeping the current result set : %s is not a valid value", current));
            }
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.currentResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.connection == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    protected final void resetResults() {
        this.currentResultSet = null;
        this.updateCount = -1;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
        this.escapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getResultSetType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException(String.format("fetch direction value of : %s is illegal", direction));
            }
        } else {
            throw new SQLSyntaxErrorException(String.format("fetch direction value of : %s is illegal", direction));
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.checkNotClosed();
        if (size < 0) {
            throw new SQLSyntaxErrorException(String.format("fetch size of : %s rows may not be negative", size));
        }
        this.fetchSize = size;
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        this.statement.setConsistencyLevel(consistencyLevel);
    }

    @Override
    public int compareTo(Object target) {
        if (this.equals(target)) {
            return 0;
        }
        if (this.hashCode() < target.hashCode()) {
            return -1;
        }
        return 1;
    }
}

