/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.github.adejanovski.cassandra.jdbc.CassandraConnection;
import com.github.adejanovski.cassandra.jdbc.CassandraResultSet;
import com.github.adejanovski.cassandra.jdbc.CassandraStatement;
import com.github.adejanovski.cassandra.jdbc.JdbcLong;
import com.github.adejanovski.cassandra.jdbc.Utils;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraPreparedStatement
extends CassandraStatement
implements java.sql.PreparedStatement {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraPreparedStatement.class);
    private int count;
    private Map<Integer, Object> bindValues = new LinkedHashMap<Integer, Object>();
    private PreparedStatement stmt;
    private BoundStatement statement;
    private ArrayList<BoundStatement> batchStatements;
    protected ResultSet currentResultSet = null;

    CassandraPreparedStatement(CassandraConnection con, String cql) throws SQLException {
        this(con, cql, 1003, 1007, 1);
    }

    CassandraPreparedStatement(CassandraConnection con, String cql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(con, cql, rsType, rsConcurrency, rsHoldability);
        if (LOG.isTraceEnabled()) {
            LOG.trace("CQL: " + this.cql);
        }
        try {
            this.stmt = this.connection.getSession().prepare(cql);
            this.statement = new BoundStatement(this.stmt);
            this.batchStatements = Lists.newArrayList();
            this.count = cql.length() - cql.replace("?", "").length();
        }
        catch (Exception e) {
            throw new SQLTransientException(e);
        }
    }

    String getCql() {
        return this.cql;
    }

    private final void checkIndex(int index) throws SQLException {
        if (index > this.count) {
            throw new SQLRecoverableException(String.format("the column index : %d is greater than the count of bound variable markers in the CQL: %d", index, this.count));
        }
        if (index < 1) {
            throw new SQLRecoverableException(String.format("the column index must be a positive number : %d", index));
        }
    }

    @Override
    public void close() {
        try {
            this.connection.removeStatement(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doExecute() throws SQLException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("CQL: " + this.cql);
        }
        try {
            this.resetResults();
            if (this.connection.debugMode) {
                System.out.println("CQL: " + this.cql);
            }
            if (this.statement.getFetchSize() == 0) {
                this.statement.setFetchSize(100);
            }
            this.statement.setConsistencyLevel(this.connection.defaultConsistencyLevel);
            for (int i = 0; i < this.statement.preparedStatement().getVariables().size(); ++i) {
                if (this.statement.isSet(i)) continue;
                this.statement.setToNull(i);
            }
            this.currentResultSet = new CassandraResultSet((CassandraStatement)this, this.connection.getSession().execute((Statement)this.statement));
        }
        catch (Exception e) {
            throw new SQLTransientException(e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchStatements.add(this.statement);
        this.statement = new BoundStatement(this.stmt);
        if (this.batchStatements.size() > 1000) {
            throw new SQLNonTransientException("Too many queries at once (" + this.batchStatements.size() + "). You must split your queries into more batches !");
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] returnCounts = new int[this.batchStatements.size()];
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            if (this.connection.debugMode) {
                System.out.println("CQL statements : " + this.batchStatements.size());
            }
            for (BoundStatement q : this.batchStatements) {
                for (int i = 0; i < q.preparedStatement().getVariables().size(); ++i) {
                    if (q.isSet(i)) continue;
                    q.setToNull(i);
                }
                if (this.connection.debugMode) {
                    System.out.println("CQL: " + this.cql);
                }
                q.setConsistencyLevel(this.connection.defaultConsistencyLevel);
                ResultSetFuture resultSetFuture = this.connection.getSession().executeAsync((Statement)q);
                futures.add(resultSetFuture);
            }
            int i = 0;
            for (ResultSetFuture future : futures) {
                future.getUninterruptibly();
                returnCounts[i] = 1;
                ++i;
            }
            this.batchStatements = Lists.newArrayList();
        }
        catch (Exception e) {
            this.batchStatements = Lists.newArrayList();
            throw new SQLTransientException(e);
        }
        return returnCounts;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        this.bindValues.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        return this.currentResultSet != null;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        if (this.currentResultSet == null) {
            throw new SQLNonTransientException("No ResultSet returned from the CQL statement passed in an 'executeQuery()' method");
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        return 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal decimal) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setDecimal(parameterIndex - 1, decimal);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean truth) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setBool(parameterIndex - 1, truth);
    }

    @Override
    public void setByte(int parameterIndex, byte b) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setBytes(parameterIndex - 1, ByteBuffer.wrap(bytes));
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setTimestamp(parameterIndex - 1, (java.util.Date)value);
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, date);
    }

    @Override
    public void setDouble(int parameterIndex, double decimal) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setDouble(parameterIndex - 1, decimal);
    }

    @Override
    public void setFloat(int parameterIndex, float decimal) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setFloat(parameterIndex - 1, decimal);
    }

    @Override
    public void setInt(int parameterIndex, int integer) throws SQLException {
        block2: {
            this.checkNotClosed();
            this.checkIndex(parameterIndex);
            try {
                this.statement.setInt(parameterIndex - 1, integer);
            }
            catch (CodecNotFoundException e) {
                if (!e.getMessage().contains("Codec not found for requested operation: [varint <-> java.lang.Integer]")) break block2;
                this.statement.setVarint(parameterIndex - 1, BigInteger.valueOf(integer));
            }
        }
    }

    @Override
    public void setLong(int parameterIndex, long bigint) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setLong(parameterIndex - 1, bigint);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setToNull(parameterIndex - 1);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object object) throws SQLException {
        int targetType = 0;
        targetType = object.getClass().equals(Long.class) ? -5 : (object.getClass().equals(ByteArrayInputStream.class) ? -2 : (object.getClass().equals(String.class) ? 12 : (object.getClass().equals(Boolean.class) ? 16 : (object.getClass().equals(BigDecimal.class) ? 3 : (object.getClass().equals(Double.class) ? 8 : (object.getClass().equals(Float.class) ? 6 : (object.getClass().equals(Inet4Address.class) ? 1111 : (object.getClass().equals(Integer.class) ? 4 : (object.getClass().equals(String.class) ? 12 : (object.getClass().equals(Timestamp.class) ? 93 : (object.getClass().equals(UUID.class) ? -8 : 1111)))))))))));
        this.setObject(parameterIndex, object, targetType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, object, targetSqlType, 0);
    }

    @Override
    public final void setObject(int parameterIndex, Object object, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        switch (targetSqlType) {
            case 12: {
                this.statement.setString(parameterIndex - 1, object.toString());
                break;
            }
            case -5: {
                this.statement.setLong(parameterIndex - 1, Long.parseLong(object.toString()));
                break;
            }
            case -2: {
                byte[] array = new byte[((ByteArrayInputStream)object).available()];
                try {
                    ((ByteArrayInputStream)object).read(array);
                }
                catch (IOException e1) {
                    LOG.warn("Exception while setting object of BINARY type", (Throwable)e1);
                }
                this.statement.setBytes(parameterIndex - 1, ByteBuffer.wrap(array));
                break;
            }
            case 16: {
                this.statement.setBool(parameterIndex - 1, ((Boolean)object).booleanValue());
                break;
            }
            case 1: {
                this.statement.setString(parameterIndex - 1, object.toString());
                break;
            }
            case 2005: {
                this.statement.setString(parameterIndex - 1, object.toString());
                break;
            }
            case 93: {
                this.statement.setTimestamp(parameterIndex - 1, (java.util.Date)((Timestamp)object));
                break;
            }
            case 3: {
                this.statement.setDecimal(parameterIndex - 1, (BigDecimal)object);
                break;
            }
            case 8: {
                this.statement.setDouble(parameterIndex - 1, ((Double)object).doubleValue());
                break;
            }
            case 6: {
                this.statement.setFloat(parameterIndex - 1, ((Float)object).floatValue());
                break;
            }
            case 4: {
                try {
                    this.statement.setInt(parameterIndex - 1, ((Integer)object).intValue());
                }
                catch (CodecNotFoundException e) {
                    if (!e.getMessage().contains("varint")) break;
                    this.statement.setVarint(parameterIndex - 1, BigInteger.valueOf(Long.parseLong(object.toString())));
                }
                break;
            }
            case 91: {
                this.statement.setTimestamp(parameterIndex - 1, (java.util.Date)((Date)object));
                break;
            }
            case -8: {
                this.statement.setUUID(parameterIndex - 1, (UUID)object);
                break;
            }
            case 1111: {
                if (object.getClass().equals(TupleValue.class)) {
                    this.statement.setTupleValue(parameterIndex - 1, (TupleValue)object);
                }
                if (object.getClass().equals(UUID.class)) {
                    this.statement.setUUID(parameterIndex - 1, (UUID)object);
                }
                if (object.getClass().equals(InetAddress.class) || object.getClass().equals(Inet4Address.class)) {
                    this.statement.setInet(parameterIndex - 1, (InetAddress)object);
                    break;
                }
                if (List.class.isAssignableFrom(object.getClass())) {
                    this.statement.setList(parameterIndex - 1, CassandraPreparedStatement.handleAsList(object.getClass(), object));
                    break;
                }
                if (Set.class.isAssignableFrom(object.getClass())) {
                    this.statement.setSet(parameterIndex - 1, CassandraPreparedStatement.handleAsSet(object.getClass(), object));
                    break;
                }
                if (!Map.class.isAssignableFrom(object.getClass())) break;
                this.statement.setMap(parameterIndex - 1, (Map)CassandraPreparedStatement.handleAsMap(object.getClass(), object));
            }
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setToNull(parameterIndex - 1);
    }

    @Override
    public void setShort(int parameterIndex, short smallint) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setInt(parameterIndex - 1, (int)smallint);
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        block4: {
            this.checkNotClosed();
            this.checkIndex(parameterIndex);
            try {
                this.statement.setString(parameterIndex - 1, value);
            }
            catch (CodecNotFoundException e) {
                if (e.getMessage().contains("set<")) {
                    String itemType = e.getMessage().substring(e.getMessage().indexOf("<") + 1, e.getMessage().indexOf(">"));
                    this.statement.setSet(parameterIndex - 1, Utils.parseSet(itemType, value));
                }
                if (e.getMessage().contains("list<")) {
                    String itemType = e.getMessage().substring(e.getMessage().indexOf("<") + 1, e.getMessage().indexOf(">"));
                    this.statement.setList(parameterIndex - 1, Utils.parseList(itemType, value));
                }
                if (!e.getMessage().contains("map<")) break block4;
                String[] kvTypes = e.getMessage().substring(e.getMessage().indexOf("<") + 1, e.getMessage().indexOf(">")).replace(" ", "").split(",");
                this.statement.setMap(parameterIndex - 1, Utils.parseMap(kvTypes[0], kvTypes[1], value));
            }
        }
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.bindValues.put(parameterIndex, value == null ? null : JdbcLong.instance.decompose(value.getTime()));
    }

    @Override
    public void setTime(int parameterIndex, Time value, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, value);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.statement.setTimestamp(parameterIndex - 1, (java.util.Date)new Date(value.getTime()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, value);
    }

    @Override
    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        String url = value.toString();
        this.setString(parameterIndex, url);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.currentResultSet;
    }

    private static final <T> List handleAsList(Class<? extends Object> objectClass, Object object) {
        if (!List.class.isAssignableFrom(objectClass)) {
            return null;
        }
        return (List)object.getClass().cast(object);
    }

    private static final <T> Set handleAsSet(Class<? extends Object> objectClass, Object object) {
        if (!Set.class.isAssignableFrom(objectClass)) {
            return null;
        }
        return (Set)object.getClass().cast(object);
    }

    private static final <K, V> HashMap handleAsMap(Class<? extends Object> objectClass, Object object) {
        if (!Map.class.isAssignableFrom(objectClass)) {
            return null;
        }
        return (HashMap)object.getClass().cast(object);
    }

    private static final Class<?> getCollectionElementType(Object maybeCollection) {
        Collection trial = (Collection)maybeCollection;
        if (trial.isEmpty()) {
            return trial.getClass();
        }
        return trial.iterator().next().getClass();
    }

    private static final Class<?> getKeyElementType(Object maybeMap) {
        return CassandraPreparedStatement.getCollectionElementType(((Map)maybeMap).keySet());
    }

    private static final Class<?> getValueElementType(Object maybeMap) {
        return CassandraPreparedStatement.getCollectionElementType(((Map)maybeMap).values());
    }

    @Override
    public void setBlob(int parameterIndex, Blob value) throws SQLException {
        InputStream in = value.getBinaryStream();
        this.setBlob(parameterIndex, in);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
        }
        catch (IOException e) {
            throw new SQLNonTransientException(e);
        }
        try {
            buffer.flush();
        }
        catch (IOException e) {
            throw new SQLNonTransientException(e);
        }
        this.statement.setBytes(parameterIndex - 1, ByteBuffer.wrap(buffer.toByteArray()));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            String targetString = CharStreams.toString((Readable)reader);
            reader.close();
            this.setString(parameterIndex, targetString);
        }
        catch (IOException e) {
            throw new SQLNonTransientException(e);
        }
    }
}

