/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.adejanovski.cassandra.jdbc.AbstractJdbcType;
import com.github.adejanovski.cassandra.jdbc.AbstractResultSet;
import com.github.adejanovski.cassandra.jdbc.CassandraResultSetExtras;
import com.github.adejanovski.cassandra.jdbc.CassandraStatement;
import com.github.adejanovski.cassandra.jdbc.ColumnDefinitions;
import com.github.adejanovski.cassandra.jdbc.JdbcAscii;
import com.github.adejanovski.cassandra.jdbc.JdbcBytes;
import com.github.adejanovski.cassandra.jdbc.JdbcInt32;
import com.github.adejanovski.cassandra.jdbc.JdbcLong;
import com.github.adejanovski.cassandra.jdbc.JdbcUTF8;
import com.github.adejanovski.cassandra.jdbc.JdbcUUID;
import com.github.adejanovski.cassandra.jdbc.MetadataResultSet;
import com.github.adejanovski.cassandra.jdbc.MetadataRow;
import com.github.adejanovski.cassandra.jdbc.TypesMap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraMetadataResultSet
extends AbstractResultSet
implements CassandraResultSetExtras {
    private static final Logger logger = LoggerFactory.getLogger(CassandraMetadataResultSet.class);
    public static final int DEFAULT_TYPE = 1003;
    public static final int DEFAULT_CONCURRENCY = 1007;
    public static final int DEFAULT_HOLDABILITY = 1;
    private MetadataRow currentRow;
    private Iterator<MetadataRow> rowsIterator;
    int rowNumber = 0;
    private byte[] curRowKey = null;
    private final CResultSetMetaData meta;
    private final CassandraStatement statement;
    private int resultSetType;
    private int fetchDirection;
    private int fetchSize;
    private boolean wasNull;
    private MetadataResultSet driverResultSet;

    CassandraMetadataResultSet() {
        this.statement = null;
        this.meta = new CResultSetMetaData();
    }

    CassandraMetadataResultSet(CassandraStatement statement, MetadataResultSet metadataResultSet) throws SQLException {
        this.statement = statement;
        this.resultSetType = statement.getResultSetType();
        this.fetchDirection = statement.getFetchDirection();
        this.fetchSize = statement.getFetchSize();
        this.driverResultSet = metadataResultSet;
        this.populateMetaData();
        this.rowsIterator = metadataResultSet.iterator();
        if (this.hasMoreRows()) {
            this.populateColumns();
        }
        this.meta = new CResultSetMetaData();
    }

    private final boolean hasMoreRows() {
        return this.rowsIterator != null && (this.rowsIterator.hasNext() || this.rowNumber == 0 && this.currentRow != null);
    }

    private final void populateMetaData() {
    }

    private final void populateColumns() {
        this.currentRow = this.rowsIterator.next();
    }

    @Override
    public boolean absolute(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLNonTransientException("Can not position cursor with a type of TYPE_FORWARD_ONLY");
        }
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLNonTransientException("Can not position cursor with a type of TYPE_FORWARD_ONLY");
        }
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    private final void checkIndex(int index) throws SQLException {
        if (this.currentRow != null) {
            this.wasNull = this.currentRow.isNull(index - 1);
            if (this.currentRow.getColumnDefinitions() != null && (index < 1 || index > this.currentRow.getColumnDefinitions().asList().size())) {
                throw new SQLSyntaxErrorException(String.format("index must be a positive number less or equal the count of returned columns: %s", String.valueOf(index)) + " " + this.currentRow.getColumnDefinitions().asList().size());
            }
        } else if (this.driverResultSet != null && this.driverResultSet.getColumnDefinitions() != null && (index < 1 || index > this.driverResultSet.getColumnDefinitions().asList().size())) {
            throw new SQLSyntaxErrorException(String.format("index must be a positive number less or equal the count of returned columns: %s", String.valueOf(index)) + " " + this.driverResultSet.getColumnDefinitions().asList().size());
        }
    }

    private final void checkName(String name) throws SQLException {
        if (this.currentRow != null) {
            this.wasNull = this.currentRow.isNull(name);
            if (!this.currentRow.getColumnDefinitions().contains(name)) {
                throw new SQLSyntaxErrorException(String.format("name provided was not in the list of valid column labels: %s", name));
            }
        } else if (this.driverResultSet != null && this.driverResultSet.getColumnDefinitions() != null && !this.driverResultSet.getColumnDefinitions().contains(name)) {
            throw new SQLSyntaxErrorException(String.format("name provided was not in the list of valid column labels: %s", name));
        }
    }

    private final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("method was called on a closed ResultSet");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.statement.close();
        }
    }

    @Override
    public int findColumn(String name) throws SQLException {
        this.checkNotClosed();
        this.checkName(name);
        return this.currentRow.getColumnDefinitions().getIndexOf(name);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        this.checkIndex(index);
        return this.currentRow.getDecimal(index - 1);
    }

    @Override
    public BigDecimal getBigDecimal(int index, int scale) throws SQLException {
        this.checkIndex(index);
        return this.currentRow.getDecimal(index - 1).setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String name) throws SQLException {
        this.checkName(name);
        return this.currentRow.getDecimal(name);
    }

    @Override
    public BigDecimal getBigDecimal(String name, int scale) throws SQLException {
        this.checkName(name);
        return this.currentRow.getDecimal(name).setScale(scale);
    }

    @Override
    public BigInteger getBigInteger(int index) throws SQLException {
        this.checkIndex(index);
        return this.currentRow.getVarint(index - 1);
    }

    @Override
    public BigInteger getBigInteger(String name) throws SQLException {
        this.checkName(name);
        return this.currentRow.getVarint(name);
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.checkIndex(index);
        return this.currentRow.getBool(index - 1);
    }

    @Override
    public boolean getBoolean(String name) throws SQLException {
        this.checkName(name);
        return this.currentRow.getBool(name);
    }

    @Override
    public byte getByte(int index) throws SQLException {
        this.checkIndex(index);
        return this.currentRow.getBytes(index - 1).get();
    }

    @Override
    public byte getByte(String name) throws SQLException {
        this.checkName(name);
        return this.currentRow.getBytes(name).get();
    }

    @Override
    public byte[] getBytes(int index) throws SQLException {
        return this.currentRow.getBytes(index - 1).array();
    }

    @Override
    public byte[] getBytes(String name) throws SQLException {
        return this.currentRow.getBytes(name).array();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public Date getDate(int index) throws SQLException {
        this.checkIndex(index);
        if (this.currentRow.getDate(index - 1) == null) {
            return null;
        }
        return new Date(this.currentRow.getDate(index - 1).getTime());
    }

    @Override
    public Date getDate(int index, Calendar calendar) throws SQLException {
        this.checkIndex(index);
        return this.getDate(index - 1);
    }

    @Override
    public Date getDate(String name) throws SQLException {
        this.checkName(name);
        if (this.currentRow.getDate(name) == null) {
            return null;
        }
        return new Date(this.currentRow.getDate(name).getTime());
    }

    @Override
    public Date getDate(String name, Calendar calendar) throws SQLException {
        this.checkName(name);
        return this.getDate(name);
    }

    @Override
    public double getDouble(int index) throws SQLException {
        this.checkIndex(index);
        try {
            if (this.currentRow.getColumnDefinitions().getType(index - 1).getName().toString().equals("float")) {
                return this.currentRow.getFloat(index - 1);
            }
            return this.currentRow.getDouble(index - 1);
        }
        catch (InvalidTypeException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public double getDouble(String name) throws SQLException {
        this.checkName(name);
        try {
            if (this.currentRow.getColumnDefinitions().getType(name).getName().toString().equals("float")) {
                return this.currentRow.getFloat(name);
            }
            return this.currentRow.getDouble(name);
        }
        catch (InvalidTypeException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public float getFloat(int index) throws SQLException {
        this.checkIndex(index);
        return this.currentRow.getFloat(index - 1);
    }

    @Override
    public float getFloat(String name) throws SQLException {
        this.checkName(name);
        return this.currentRow.getFloat(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public int getInt(int index) throws SQLException {
        this.checkIndex(index);
        return this.currentRow.getInt(index - 1);
    }

    @Override
    public int getInt(String name) throws SQLException {
        this.checkName(name);
        return this.currentRow.getInt(name);
    }

    @Override
    public byte[] getKey() throws SQLException {
        return this.curRowKey;
    }

    @Override
    public List<?> getList(int index) throws SQLException {
        this.checkIndex(index);
        if (this.currentRow.getColumnDefinitions().getType(index - 1).isCollection()) {
            try {
                return Lists.newArrayList(this.currentRow.getList(index - 1, Class.forName(((DataType)this.currentRow.getColumnDefinitions().getType(index - 1).getTypeArguments().get(0)).getClass().getCanonicalName())));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.currentRow.getList(index - 1, String.class);
    }

    @Override
    public List<?> getList(String name) throws SQLException {
        this.checkName(name);
        if (this.currentRow.getColumnDefinitions().getType(name).isCollection()) {
            try {
                return Lists.newArrayList(this.currentRow.getList(name, Class.forName(((DataType)this.currentRow.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getClass().getCanonicalName())));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.currentRow.getList(name, String.class);
    }

    @Override
    public long getLong(int index) throws SQLException {
        this.checkIndex(index);
        try {
            if (this.currentRow.getColumnDefinitions().getType(index - 1).getName().toString().equals("int")) {
                return this.currentRow.getInt(index - 1);
            }
            if (this.currentRow.getColumnDefinitions().getType(index - 1).getName().toString().equals("varint")) {
                return this.currentRow.getVarint(index - 1).longValue();
            }
            return this.currentRow.getLong(index - 1);
        }
        catch (InvalidTypeException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public long getLong(String name) throws SQLException {
        this.checkName(name);
        try {
            if (this.currentRow.getColumnDefinitions().getType(name).getName().toString().equals("int")) {
                return this.currentRow.getInt(name);
            }
            if (this.currentRow.getColumnDefinitions().getType(name).getName().toString().equals("varint")) {
                return this.currentRow.getVarint(name).longValue();
            }
            return this.currentRow.getLong(name);
        }
        catch (InvalidTypeException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public Map<?, ?> getMap(int index) throws SQLException {
        this.checkIndex(index);
        this.wasNull = this.currentRow.isNull(index - 1);
        return this.currentRow.getMap(index - 1, String.class, String.class);
    }

    @Override
    public Map<?, ?> getMap(String name) throws SQLException {
        this.checkName(name);
        return this.currentRow.getMap(name, String.class, String.class);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return this.meta;
    }

    @Override
    public Object getObject(int index) throws SQLException {
        this.checkIndex(index);
        String typeName = this.currentRow.getColumnDefinitions().getType(index - 1).getName().toString();
        if (typeName.equals("varchar")) {
            return this.currentRow.getString(index - 1);
        }
        if (typeName.equals("ascii")) {
            return this.currentRow.getString(index - 1);
        }
        if (typeName.equals("integer")) {
            return this.currentRow.getInt(index - 1);
        }
        if (typeName.equals("bigint")) {
            return this.currentRow.getLong(index - 1);
        }
        if (typeName.equals("blob")) {
            return this.currentRow.getBytes(index - 1);
        }
        if (typeName.equals("boolean")) {
            return this.currentRow.getBool(index - 1);
        }
        if (typeName.equals("counter")) {
            return this.currentRow.getLong(index - 1);
        }
        if (typeName.equals("decimal")) {
            return this.currentRow.getDecimal(index - 1);
        }
        if (typeName.equals("double")) {
            return this.currentRow.getDouble(index - 1);
        }
        if (typeName.equals("float")) {
            return Float.valueOf(this.currentRow.getFloat(index - 1));
        }
        if (typeName.equals("inet")) {
            return this.currentRow.getInet(index - 1);
        }
        if (typeName.equals("int")) {
            return this.currentRow.getInt(index - 1);
        }
        if (typeName.equals("text")) {
            return this.currentRow.getString(index - 1);
        }
        if (typeName.equals("timestamp")) {
            return new Timestamp(this.currentRow.getDate(index - 1).getTime());
        }
        if (typeName.equals("uuid")) {
            return this.currentRow.getUUID(index - 1);
        }
        if (typeName.equals("timeuuid")) {
            return this.currentRow.getUUID(index - 1);
        }
        if (typeName.equals("varint")) {
            return this.currentRow.getInt(index - 1);
        }
        return null;
    }

    @Override
    public Object getObject(String name) throws SQLException {
        this.checkName(name);
        String typeName = this.currentRow.getColumnDefinitions().getType(name).getName().toString();
        if (typeName.equals("varchar")) {
            return this.currentRow.getString(name);
        }
        if (typeName.equals("ascii")) {
            return this.currentRow.getString(name);
        }
        if (typeName.equals("integer")) {
            return this.currentRow.getInt(name);
        }
        if (typeName.equals("bigint")) {
            return this.currentRow.getLong(name);
        }
        if (typeName.equals("blob")) {
            return this.currentRow.getBytes(name);
        }
        if (typeName.equals("boolean")) {
            return this.currentRow.getBool(name);
        }
        if (typeName.equals("counter")) {
            return this.currentRow.getLong(name);
        }
        if (typeName.equals("decimal")) {
            return this.currentRow.getDecimal(name);
        }
        if (typeName.equals("double")) {
            return this.currentRow.getDouble(name);
        }
        if (typeName.equals("float")) {
            return Float.valueOf(this.currentRow.getFloat(name));
        }
        if (typeName.equals("inet")) {
            return this.currentRow.getInet(name);
        }
        if (typeName.equals("int")) {
            return this.currentRow.getInt(name);
        }
        if (typeName.equals("text")) {
            return this.currentRow.getString(name);
        }
        if (typeName.equals("timestamp")) {
            return new Timestamp(this.currentRow.getDate(name).getTime());
        }
        if (typeName.equals("uuid")) {
            return this.currentRow.getUUID(name);
        }
        if (typeName.equals("timeuuid")) {
            return this.currentRow.getUUID(name);
        }
        if (typeName.equals("varint")) {
            return this.currentRow.getInt(name);
        }
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber;
    }

    @Override
    public short getShort(int index) throws SQLException {
        this.checkIndex(index);
        return (short)this.currentRow.getInt(index - 1);
    }

    @Override
    public Set<?> getSet(int index) throws SQLException {
        this.checkIndex(index);
        try {
            return this.currentRow.getSet(index - 1, Class.forName(((DataType)this.currentRow.getColumnDefinitions().getType(index - 1).getTypeArguments().get(0)).getClass().getCanonicalName()));
        }
        catch (ClassNotFoundException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public Set<?> getSet(String name) throws SQLException {
        this.checkName(name);
        try {
            return this.currentRow.getSet(name, Class.forName(((DataType)this.currentRow.getColumnDefinitions().getType(name).getTypeArguments().get(0)).getClass().getCanonicalName()));
        }
        catch (ClassNotFoundException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public short getShort(String name) throws SQLException {
        this.checkName(name);
        return (short)this.currentRow.getInt(name);
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkNotClosed();
        return this.statement;
    }

    @Override
    public String getString(int index) throws SQLException {
        this.checkIndex(index);
        try {
            if (this.currentRow.getColumnDefinitions().getType(index - 1).isCollection()) {
                return this.getObject(index).toString();
            }
            return this.currentRow.getString(index - 1);
        }
        catch (Exception e) {
            return this.getObject(index).toString();
        }
    }

    @Override
    public String getString(String name) throws SQLException {
        this.checkName(name);
        try {
            if (this.currentRow.getColumnDefinitions().getType(name).isCollection()) {
                return this.getObject(name).toString();
            }
            return this.currentRow.getString(name);
        }
        catch (Exception e) {
            return this.getObject(name).toString();
        }
    }

    @Override
    public Time getTime(int index) throws SQLException {
        this.checkIndex(index);
        java.util.Date date = this.currentRow.getDate(index - 1);
        if (date == null) {
            return null;
        }
        return new Time(this.currentRow.getDate(index - 1).getTime());
    }

    @Override
    public Time getTime(int index, Calendar calendar) throws SQLException {
        this.checkIndex(index);
        java.util.Date date = this.currentRow.getDate(index - 1);
        if (date == null) {
            return null;
        }
        return this.getTime(index - 1);
    }

    @Override
    public Time getTime(String name) throws SQLException {
        this.checkName(name);
        java.util.Date date = this.currentRow.getDate(name);
        if (date == null) {
            return null;
        }
        return new Time(this.currentRow.getDate(name).getTime());
    }

    @Override
    public Time getTime(String name, Calendar calendar) throws SQLException {
        this.checkName(name);
        return this.getTime(name);
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        this.checkIndex(index);
        java.util.Date date = this.currentRow.getDate(index - 1);
        if (date == null) {
            return null;
        }
        return new Timestamp(this.currentRow.getDate(index - 1).getTime());
    }

    @Override
    public Timestamp getTimestamp(int index, Calendar calendar) throws SQLException {
        this.checkIndex(index);
        java.util.Date date = this.currentRow.getDate(index - 1);
        if (date == null) {
            return null;
        }
        return this.getTimestamp(index - 1);
    }

    @Override
    public Timestamp getTimestamp(String name) throws SQLException {
        this.checkName(name);
        java.util.Date date = this.currentRow.getDate(name);
        if (date == null) {
            return null;
        }
        return new Timestamp(this.currentRow.getDate(name).getTime());
    }

    @Override
    public Timestamp getTimestamp(String name, Calendar calendar) throws SQLException {
        this.checkName(name);
        return this.getTimestamp(name);
    }

    @Override
    public int getType() throws SQLException {
        this.checkNotClosed();
        return this.resultSetType;
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == Integer.MAX_VALUE;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.statement == null) {
            return true;
        }
        return this.statement.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return !this.rowsIterator.hasNext();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return CassandraResultSetExtras.class.isAssignableFrom(iface);
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.hasMoreRows()) {
            if (this.rowNumber != 0) {
                this.populateColumns();
            }
            ++this.rowNumber;
            return true;
        }
        this.rowNumber = Integer.MAX_VALUE;
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException("attempt to set an illegal direction : " + direction);
            }
            this.fetchDirection = direction;
        }
        throw new SQLSyntaxErrorException(String.format("fetch direction value of : %s is illegal", direction));
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.checkNotClosed();
        if (size < 0) {
            throw new SQLException(String.format("fetch size of : %s rows may not be negative", size));
        }
        this.fetchSize = size;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(CassandraResultSetExtras.class)) {
            return (T)this;
        }
        throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        byte[] bytes = new byte[this.currentRow.getBytes(columnIndex - 1).remaining()];
        this.currentRow.getBytes(columnIndex - 1).get(bytes, 0, bytes.length);
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        byte[] bytes = new byte[this.currentRow.getBytes(columnLabel).remaining()];
        this.currentRow.getBytes(columnLabel).get(bytes, 0, bytes.length);
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public Blob getBlob(int index) throws SQLException {
        this.checkIndex(index);
        return new SerialBlob(this.currentRow.getBytes(index - 1).array());
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        this.checkName(columnName);
        return new SerialBlob(this.currentRow.getBytes(columnName).array());
    }

    class CResultSetMetaData
    implements ResultSetMetaData {
        CResultSetMetaData() {
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            return ((CassandraMetadataResultSet)CassandraMetadataResultSet.this).statement.connection.getCatalog();
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            if (CassandraMetadataResultSet.this.currentRow != null) {
                return CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().getType(column - 1).getName().toString();
            }
            return ((ColumnDefinitions.Definition)CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1)).getType().getName().toString();
        }

        @Override
        public int getColumnCount() throws SQLException {
            if (CassandraMetadataResultSet.this.currentRow != null) {
                return CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().size();
            }
            return CassandraMetadataResultSet.this.driverResultSet != null && CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions() != null ? CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().size() : 0;
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            try {
                ColumnDefinitions.Definition col;
                AbstractJdbcType<?> jtype = null;
                if (CassandraMetadataResultSet.this.currentRow != null) {
                    col = CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().asList().get(column - 1);
                    jtype = TypesMap.getTypeForComparator(col.getType().toString());
                } else {
                    col = (ColumnDefinitions.Definition)CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1);
                    jtype = TypesMap.getTypeForComparator(col.getType().toString());
                }
                int length = -1;
                if (jtype instanceof JdbcBytes) {
                    length = 0x3FFFFFFF;
                }
                if (jtype instanceof JdbcAscii || jtype instanceof JdbcUTF8) {
                    length = Integer.MAX_VALUE;
                }
                if (jtype instanceof JdbcUUID) {
                    length = 36;
                }
                if (jtype instanceof JdbcInt32) {
                    length = 4;
                }
                if (jtype instanceof JdbcLong) {
                    length = 8;
                }
                return length;
            }
            catch (Exception e) {
                return -1;
            }
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            return this.getColumnName(column);
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            try {
                if (CassandraMetadataResultSet.this.currentRow != null) {
                    return CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().getName(column - 1);
                }
                return ((ColumnDefinitions.Definition)CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1)).getName();
            }
            catch (Exception e) {
                return "";
            }
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            DataType type = null;
            type = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().getType(column - 1) : ((ColumnDefinitions.Definition)CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1)).getType();
            return TypesMap.getTypeForComparator(type.toString()).getJdbcType();
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            DataType type = null;
            try {
                type = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().getType(column - 1) : CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().getType(column - 1);
                return type.toString();
            }
            catch (Exception e) {
                return DataType.varchar().toString();
            }
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            return 0;
        }

        @Override
        public int getScale(int column) throws SQLException {
            return 0;
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            return ((CassandraMetadataResultSet)CassandraMetadataResultSet.this).statement.connection.getSchema();
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            return true;
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            return true;
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            return this.isWritable(column);
        }

        @Override
        public int isNullable(int column) throws SQLException {
            return 1;
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            return column == 0;
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            return false;
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            return false;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            return column > 0;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
        }

        @Override
        public String getTableName(int column) throws SQLException {
            String tableName = "";
            tableName = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().getTable(column - 1) : CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().getTable(column - 1);
            return tableName;
        }
    }
}

