/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UserType;
import com.github.adejanovski.cassandra.jdbc.AbstractConnection;
import com.github.adejanovski.cassandra.jdbc.CassandraDatabaseMetaData;
import com.github.adejanovski.cassandra.jdbc.CassandraPreparedStatement;
import com.github.adejanovski.cassandra.jdbc.CassandraStatement;
import com.github.adejanovski.cassandra.jdbc.SessionHolder;
import com.github.adejanovski.cassandra.jdbc.Utils;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraConnection
extends AbstractConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(CassandraConnection.class);
    public static Integer roundRobinIndex;
    static final String IS_VALID_CQLQUERY_2_0_0 = "SELECT COUNT(1) FROM system.Versions WHERE component = 'cql';";
    static final String IS_VALID_CQLQUERY_3_0_0 = "SELECT COUNT(1) FROM system.\"Versions\" WHERE component = 'cql';";
    public static volatile int DB_MAJOR_VERSION;
    public static volatile int DB_MINOR_VERSION;
    public static volatile int DB_REVISION;
    public static final String DB_PRODUCT_NAME = "Cassandra";
    public static final String DEFAULT_CQL_VERSION = "3.0.0";
    public ConcurrentMap<String, CassandraPreparedStatement> preparedStatements = Maps.newConcurrentMap();
    public static ProtocolOptions.Compression defaultCompression;
    private final boolean autoCommit = true;
    private final int transactionIsolation = 0;
    private final SessionHolder sessionHolder;
    private Properties connectionProps;
    private Properties clientInfo = new Properties();
    private Set<Statement> statements = new ConcurrentSkipListSet<Statement>();
    private Session cSession;
    protected long timeOfLastFailure = 0L;
    protected int numFailures = 0;
    protected String username = null;
    protected String url = null;
    public String cluster;
    protected String currentKeyspace;
    protected TreeSet<String> hostListPrimary;
    protected TreeSet<String> hostListBackup;
    int majorCqlVersion;
    private Metadata metadata;
    public boolean debugMode;
    private volatile boolean isClosed;
    PreparedStatement isAlive = null;
    public ConsistencyLevel defaultConsistencyLevel;

    public CassandraConnection(SessionHolder sessionHolder) throws SQLException {
        this.sessionHolder = sessionHolder;
        Properties props = sessionHolder.properties;
        this.debugMode = props.getProperty("debug", "").equals("true");
        this.hostListPrimary = new TreeSet();
        this.hostListBackup = new TreeSet();
        this.connectionProps = (Properties)props.clone();
        this.clientInfo = new Properties();
        this.url = "jdbc:cassandra:" + Utils.createSubName(props);
        this.currentKeyspace = props.getProperty("databaseName");
        this.username = props.getProperty("user", "");
        String version = props.getProperty("cqlVersion", DEFAULT_CQL_VERSION);
        this.connectionProps.setProperty("activeCqlVersion", version);
        this.majorCqlVersion = this.getMajor(version);
        this.defaultConsistencyLevel = ConsistencyLevel.valueOf((String)props.getProperty("consistencyLevel", ConsistencyLevel.ONE.name()));
        this.cSession = sessionHolder.session;
        this.metadata = this.cSession.getCluster().getMetadata();
        logger.info("Connected to cluster: %s\n", (Object)this.metadata.getClusterName());
        for (Host aHost : this.metadata.getAllHosts()) {
            logger.info("Datacenter: %s; Host: %s; Rack: %s\n", new Object[]{aHost.getDatacenter(), aHost.getAddress(), aHost.getRack()});
        }
        Iterator hosts = this.metadata.getAllHosts().iterator();
        if (hosts.hasNext()) {
            Host firstHost = (Host)hosts.next();
            DB_MAJOR_VERSION = firstHost.getCassandraVersion().getMajor();
            DB_MINOR_VERSION = firstHost.getCassandraVersion().getMinor();
            DB_REVISION = firstHost.getCassandraVersion().getPatch();
        }
    }

    private final int getMajor(String version) {
        int major = 0;
        String[] parts = version.split("\\.");
        try {
            major = Integer.valueOf(parts[0]);
        }
        catch (Exception e) {
            major = 2;
        }
        return major;
    }

    private final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLNonTransientConnectionException("method was called on a closed Connection");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        this.sessionHolder.release();
        this.isClosed = true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this, null, resultSetType, resultSetConcurrency);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this, null, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkNotClosed();
        return true;
    }

    public Properties getConnectionProps() {
        return this.connectionProps;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkNotClosed();
        return this.metadata.getClusterName();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkNotClosed();
        this.currentKeyspace = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkNotClosed();
        return this.currentKeyspace;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String label) throws SQLException {
        this.checkNotClosed();
        return this.clientInfo.getProperty(label);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return new CassandraDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLTimeoutException {
        if (timeout < 0) {
            throw new SQLTimeoutException("the timeout value was less than zero");
        }
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkNotClosed();
        return sql;
    }

    @Override
    public CassandraPreparedStatement prepareStatement(String cql) throws SQLException {
        CassandraPreparedStatement prepStmt = (CassandraPreparedStatement)this.preparedStatements.get(cql);
        if (prepStmt == null && (prepStmt = this.preparedStatements.putIfAbsent(cql, this.prepareStatement(cql, 1003, 1007, 1))) == null) {
            return (CassandraPreparedStatement)this.preparedStatements.get(cql);
        }
        return prepStmt;
    }

    @Override
    public CassandraPreparedStatement prepareStatement(String cql, int rsType) throws SQLException {
        return this.prepareStatement(cql, rsType, 1007, 1);
    }

    @Override
    public CassandraPreparedStatement prepareStatement(String cql, int rsType, int rsConcurrency) throws SQLException {
        return this.prepareStatement(cql, rsType, rsConcurrency, 1);
    }

    @Override
    public CassandraPreparedStatement prepareStatement(String cql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.checkNotClosed();
        CassandraPreparedStatement statement = new CassandraPreparedStatement(this, cql, rsType, rsConcurrency, rsHoldability);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("the Cassandra implementation is always in auto-commit mode");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (props != null) {
            this.clientInfo = props;
        }
    }

    @Override
    public void setClientInfo(String key, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(key, value);
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
        if (level != 0) {
            throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support transactions");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    protected boolean removeStatement(Statement statement) {
        return this.statements.remove(statement);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CassandraConnection [connectionProps=");
        builder.append(this.connectionProps);
        builder.append("]");
        return builder.toString();
    }

    public Session getSession() {
        return this.cSession;
    }

    public Metadata getClusterMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        HashMap typeMap = new HashMap();
        logger.info("current KS : " + this.currentKeyspace);
        Collection types = this.metadata.getKeyspace(this.currentKeyspace).getUserTypes();
        for (UserType type : types) {
            typeMap.put(type.getTypeName(), type.getClass());
        }
        return typeMap;
    }

    static {
        DB_MAJOR_VERSION = 1;
        DB_MINOR_VERSION = 2;
        DB_REVISION = 2;
        defaultCompression = ProtocolOptions.Compression.LZ4;
    }
}

